/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.values.storable.ValueGroup;

public class DefaultCapableIndexReference
implements CapableIndexReference {
    private final int label;
    private final int[] properties;
    private final boolean unique;
    private final IndexProvider.Descriptor providerDescriptor;
    private final IndexCapability capability;

    public DefaultCapableIndexReference(boolean unique, IndexCapability indexCapability, IndexProvider.Descriptor providerDescriptor, int label, int ... properties) {
        this.unique = unique;
        this.capability = indexCapability;
        this.label = label;
        this.providerDescriptor = providerDescriptor;
        this.properties = properties;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int label() {
        return this.label;
    }

    public int[] properties() {
        return this.properties;
    }

    public String providerKey() {
        return this.providerDescriptor.getKey();
    }

    public String providerVersion() {
        return this.providerDescriptor.getVersion();
    }

    public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
        return this.capability.orderCapability(valueGroups);
    }

    public IndexValueCapability valueCapability(ValueGroup ... valueGroups) {
        return this.capability.valueCapability(valueGroups);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IndexReference)) {
            return false;
        }
        IndexReference that = (IndexReference)o;
        return this.label == that.label() && this.unique == that.isUnique() && Arrays.equals(this.properties, that.properties());
    }

    public String toString() {
        return String.format("Index(%d:%s)", this.label, Arrays.toString(this.properties));
    }

    public int hashCode() {
        int result = this.label;
        result = 31 * result + Arrays.hashCode(this.properties);
        result = 31 * result + (this.unique ? 1 : 0);
        result = 31 * result + (this.providerDescriptor != null ? this.providerDescriptor.hashCode() : 0);
        return result;
    }

    public static CapableIndexReference fromDescriptor(SchemaIndexDescriptor descriptor) {
        boolean unique = descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE;
        LabelSchemaDescriptor schema = descriptor.schema();
        return new DefaultCapableIndexReference(unique, IndexCapability.NO_CAPABILITY, null, schema.getLabelId(), schema.getPropertyIds());
    }
}

