/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<InwardKernel> kernelSupplier;
    private final PropertyAccessor propertyAccessor;

    public ConstraintIndexCreator(Supplier<InwardKernel> kernelSupplier, IndexingService indexingService, PropertyAccessor propertyAccessor) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
        this.propertyAccessor = propertyAccessor;
    }

    @Deprecated
    public long createUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor descriptor) throws TransactionFailureException, CreateConstraintFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        SchemaIndexDescriptor index;
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
        try {
            index = this.getOrCreateUniquenessConstraintIndex(state, schemaOps, descriptor);
        }
        catch (AlreadyConstrainedException e) {
            throw e;
        }
        catch (SchemaKernelException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        boolean success = false;
        boolean reacquiredLabelLock = false;
        Locks.Client locks = state.locks().pessimistic();
        try {
            long indexId = schemaOps.indexGetCommittedId(state, index);
            IndexProxy proxy = this.indexingService.getIndexProxy(indexId);
            this.releaseLabelLock(locks, descriptor.getLabelId());
            this.awaitConstrainIndexPopulation(constraint, proxy);
            this.acquireLabelLock(state, locks, descriptor.getLabelId());
            reacquiredLabelLock = true;
            this.indexingService.getIndexProxy(indexId).verifyDeferredConstraints(this.propertyAccessor);
            success = true;
            long l = indexId;
            return l;
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor), (Throwable)((Object)e));
        }
        catch (IndexNotFoundKernelException e) {
            throw new TransactionFailureException(String.format("Index (%s) that we just created does not exist.", descriptor), e);
        }
        catch (IndexEntryConflictException e) {
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, e);
        }
        catch (IOException | InterruptedException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        finally {
            if (!success) {
                if (!reacquiredLabelLock) {
                    this.acquireLabelLock(state, locks, descriptor.getLabelId());
                }
                if (this.indexStillExists(schemaOps, state, descriptor, index)) {
                    this.dropUniquenessConstraintIndex(index);
                }
            }
        }
    }

    public long createUniquenessConstraintIndex(KernelTransactionImplementation transaction, LabelSchemaDescriptor descriptor) throws TransactionFailureException, CreateConstraintFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        CapableIndexReference index;
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
        SchemaRead schemaRead = transaction.schemaRead();
        try {
            index = this.getOrCreateUniquenessConstraintIndex(schemaRead, transaction.tokenRead(), descriptor);
        }
        catch (AlreadyConstrainedException e) {
            throw e;
        }
        catch (SchemaKernelException | IndexNotFoundKernelException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        boolean success = false;
        boolean reacquiredLabelLock = false;
        Locks.Client locks = transaction.statementLocks().pessimistic();
        try {
            long indexId = schemaRead.indexGetCommittedId((IndexReference)index);
            IndexProxy proxy = this.indexingService.getIndexProxy(indexId);
            this.releaseLabelLock(locks, descriptor.getLabelId());
            this.awaitConstrainIndexPopulation(constraint, proxy);
            this.acquireLabelLock(transaction, locks, descriptor.getLabelId());
            reacquiredLabelLock = true;
            this.indexingService.getIndexProxy(indexId).verifyDeferredConstraints(this.propertyAccessor);
            success = true;
            long l = indexId;
            return l;
        }
        catch (SchemaKernelException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor), e);
        }
        catch (IndexNotFoundKernelException e) {
            throw new TransactionFailureException(String.format("Index (%s) that we just created does not exist.", descriptor), e);
        }
        catch (IndexEntryConflictException e) {
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, e);
        }
        catch (IOException | InterruptedException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        finally {
            if (!success) {
                if (!reacquiredLabelLock) {
                    this.acquireLabelLock(transaction, locks, descriptor.getLabelId());
                }
                if (this.indexStillExists(schemaRead, descriptor, index)) {
                    this.dropUniquenessConstraintIndex(this.asDescriptor(index));
                }
            }
        }
    }

    private boolean indexStillExists(SchemaReadOperations schemaOps, KernelStatement state, LabelSchemaDescriptor descriptor, SchemaIndexDescriptor index) {
        SchemaIndexDescriptor existingIndex = schemaOps.indexGetForSchema(state, descriptor);
        return existingIndex != null && existingIndex.equals(index);
    }

    private boolean indexStillExists(SchemaRead schemaRead, LabelSchemaDescriptor descriptor, CapableIndexReference index) {
        CapableIndexReference existingIndex = schemaRead.index(descriptor.getLabelId(), descriptor.getPropertyIds());
        return existingIndex != CapableIndexReference.NO_INDEX && existingIndex.equals(index);
    }

    private void acquireLabelLock(KernelStatement state, Locks.Client locks, int labelId) {
        locks.acquireExclusive(state.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void acquireLabelLock(KernelTransactionImplementation state, Locks.Client locks, int labelId) {
        locks.acquireExclusive(state.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void releaseLabelLock(Locks.Client locks, int labelId) {
        locks.releaseExclusive(ResourceTypes.LABEL, labelId);
    }

    public void dropUniquenessConstraintIndex(SchemaIndexDescriptor descriptor) throws TransactionFailureException {
        try (KernelTransaction transaction = this.kernelSupplier.get().newTransaction(Transaction.Type.implicit, (LoginContext)SecurityContext.AUTH_DISABLED);
             Statement ignore = transaction.acquireStatement();){
            ((KernelTransactionImplementation)transaction).txState().indexDoDrop(descriptor);
            transaction.success();
        }
    }

    private SchemaIndexDescriptor asDescriptor(CapableIndexReference indexReference) {
        if (indexReference.isUnique()) {
            return SchemaIndexDescriptorFactory.uniqueForLabel(indexReference.label(), indexReference.properties());
        }
        return SchemaIndexDescriptorFactory.forLabel(indexReference.label(), indexReference.properties());
    }

    private void awaitConstrainIndexPopulation(UniquenessConstraintDescriptor constraint, IndexProxy proxy) throws InterruptedException, UniquePropertyValueValidationException {
        try {
            proxy.awaitStoreScanCompleted();
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (IndexEntryConflictException)cause);
            }
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (Throwable)((Object)e));
        }
    }

    private SchemaIndexDescriptor getOrCreateUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor schema) throws SchemaKernelException {
        SchemaIndexDescriptor descriptor = schemaOps.indexGetForSchema(state, schema);
        if (descriptor != null) {
            if (descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE) {
                if (schemaOps.indexGetOwningUniquenessConstraintId(state, descriptor) == null) {
                    return descriptor;
                }
                throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
            }
            throw new AlreadyIndexedException(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        return this.createConstraintIndex(schema);
    }

    private CapableIndexReference getOrCreateUniquenessConstraintIndex(SchemaRead schemaRead, TokenRead tokenRead, LabelSchemaDescriptor schema) throws SchemaKernelException, IndexNotFoundKernelException {
        CapableIndexReference descriptor = schemaRead.index(schema.getLabelId(), schema.getPropertyIds());
        if (descriptor != CapableIndexReference.NO_INDEX) {
            if (descriptor.isUnique()) {
                if (schemaRead.indexGetOwningUniquenessConstraintId((IndexReference)descriptor) == null) {
                    return descriptor;
                }
                throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new SilentTokenNameLookup(tokenRead));
            }
            throw new AlreadyIndexedException(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        SchemaIndexDescriptor indexDescriptor = this.createConstraintIndex(schema);
        IndexProxy indexProxy = this.indexingService.getIndexProxy(indexDescriptor.schema());
        return new DefaultCapableIndexReference(indexDescriptor.type() == SchemaIndexDescriptor.Type.UNIQUE, indexProxy.getIndexCapability(), indexProxy.getProviderDescriptor(), indexDescriptor.schema().getLabelId(), indexDescriptor.schema().getPropertyIds());
    }

    /*
     * Exception decompiling
     */
    public SchemaIndexDescriptor createConstraintIndex(LabelSchemaDescriptor schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

