/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveArrays;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.values.storable.Value;

public class NodeUpdates
implements PropertyLoader.PropertyLoadSink {
    private final long nodeId;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final long[] labelsBefore;
    private final long[] labelsAfter;
    private final PrimitiveIntObjectMap<PropertyValue> knownProperties;
    private boolean hasLoadedAdditionalProperties;
    private static PropertyValue noValue = new PropertyValue(null, null, PropertyValueType.NoValue);

    private void put(int propertyKeyId, PropertyValue propertyValue) {
        this.knownProperties.put(propertyKeyId, (Object)propertyValue);
    }

    public static Builder forNode(long nodeId) {
        return new Builder(new NodeUpdates(nodeId, EMPTY_LONG_ARRAY, EMPTY_LONG_ARRAY));
    }

    public static Builder forNode(long nodeId, long[] labels) {
        return new Builder(new NodeUpdates(nodeId, labels, labels));
    }

    public static Builder forNode(long nodeId, long[] labelsBefore, long[] labelsAfter) {
        return new Builder(new NodeUpdates(nodeId, labelsBefore, labelsAfter));
    }

    private NodeUpdates(long nodeId, long[] labelsBefore, long[] labelsAfter) {
        this.nodeId = nodeId;
        this.labelsBefore = labelsBefore;
        this.labelsAfter = labelsAfter;
        this.knownProperties = Primitive.intObjectMap();
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    long[] labelsChanged() {
        return PrimitiveArrays.symmetricDifference((long[])this.labelsBefore, (long[])this.labelsAfter);
    }

    long[] labelsUnchanged() {
        return PrimitiveArrays.intersect((long[])this.labelsBefore, (long[])this.labelsAfter);
    }

    PrimitiveIntSet propertiesChanged() {
        assert (!this.hasLoadedAdditionalProperties) : "Calling propertiesChanged() is not valid after non-changed properties have already been loaded.";
        return PrimitiveIntCollections.asSet((PrimitiveIntIterator)this.knownProperties.iterator());
    }

    @Override
    public void onProperty(int propertyId, Value value) {
        this.knownProperties.put(propertyId, (Object)NodeUpdates.unchanged(value));
    }

    public <INDEX_KEY extends LabelSchemaSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> forIndexKeys(Iterable<INDEX_KEY> indexKeys) {
        Iterable potentiallyRelevant = Iterables.filter(this::atLeastOneRelevantChange, indexKeys);
        return this.gatherUpdatesForPotentials(potentiallyRelevant);
    }

    public <INDEX_KEY extends LabelSchemaSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> forIndexKeys(Iterable<INDEX_KEY> indexKeys, PropertyLoader propertyLoader) {
        ArrayList<LabelSchemaSupplier> potentiallyRelevant = new ArrayList<LabelSchemaSupplier>();
        PrimitiveIntSet additionalPropertiesToLoad = Primitive.intSet();
        for (LabelSchemaSupplier indexKey : indexKeys) {
            if (!this.atLeastOneRelevantChange(indexKey)) continue;
            potentiallyRelevant.add(indexKey);
            this.gatherPropsToLoad(indexKey.schema(), additionalPropertiesToLoad);
        }
        if (!additionalPropertiesToLoad.isEmpty()) {
            this.loadProperties(propertyLoader, additionalPropertiesToLoad);
        }
        return this.gatherUpdatesForPotentials(potentiallyRelevant);
    }

    private <INDEX_KEY extends LabelSchemaSupplier> Iterable<IndexEntryUpdate<INDEX_KEY>> gatherUpdatesForPotentials(Iterable<INDEX_KEY> potentiallyRelevant) {
        ArrayList<IndexEntryUpdate<INDEX_KEY>> indexUpdates = new ArrayList<IndexEntryUpdate<INDEX_KEY>>();
        for (LabelSchemaSupplier indexKey : potentiallyRelevant) {
            LabelSchemaDescriptor schema = indexKey.schema();
            boolean relevantBefore = this.relevantBefore(schema);
            boolean relevantAfter = this.relevantAfter(schema);
            int[] propertyIds = schema.getPropertyIds();
            if (relevantBefore && !relevantAfter) {
                indexUpdates.add(IndexEntryUpdate.remove(this.nodeId, indexKey, this.valuesBefore(propertyIds)));
                continue;
            }
            if (!relevantBefore && relevantAfter) {
                indexUpdates.add(IndexEntryUpdate.add(this.nodeId, indexKey, this.valuesAfter(propertyIds)));
                continue;
            }
            if (!relevantBefore || !this.valuesChanged(propertyIds)) continue;
            indexUpdates.add(IndexEntryUpdate.change(this.nodeId, indexKey, this.valuesBefore(propertyIds), this.valuesAfter(propertyIds)));
        }
        return indexUpdates;
    }

    private boolean relevantBefore(LabelSchemaDescriptor schema) {
        return this.hasLabel(schema.getLabelId(), this.labelsBefore) && this.hasPropsBefore(schema.getPropertyIds());
    }

    private boolean relevantAfter(LabelSchemaDescriptor schema) {
        return this.hasLabel(schema.getLabelId(), this.labelsAfter) && this.hasPropsAfter(schema.getPropertyIds());
    }

    private void loadProperties(PropertyLoader propertyLoader, PrimitiveIntSet additionalPropertiesToLoad) {
        this.hasLoadedAdditionalProperties = true;
        propertyLoader.loadProperties(this.nodeId, additionalPropertiesToLoad, this);
        PrimitiveIntIterator propertiesWithNoValue = additionalPropertiesToLoad.iterator();
        while (propertiesWithNoValue.hasNext()) {
            this.knownProperties.put(propertiesWithNoValue.next(), (Object)noValue);
        }
    }

    private void gatherPropsToLoad(LabelSchemaDescriptor schema, PrimitiveIntSet target) {
        for (int propertyId : schema.getPropertyIds()) {
            if (this.knownProperties.get(propertyId) != null) continue;
            target.add(propertyId);
        }
    }

    private boolean atLeastOneRelevantChange(LabelSchemaSupplier indexKey) {
        int labelId = indexKey.schema().getLabelId();
        boolean labelBefore = this.hasLabel(labelId, this.labelsBefore);
        boolean labelAfter = this.hasLabel(labelId, this.labelsAfter);
        if (labelBefore && labelAfter) {
            for (int propertyId : indexKey.schema().getPropertyIds()) {
                if (this.knownProperties.get(propertyId) == null) continue;
                return true;
            }
            return false;
        }
        return labelBefore || labelAfter;
    }

    private boolean hasLabel(int labelId, long[] labels) {
        return Arrays.binarySearch(labels, (long)labelId) >= 0;
    }

    private boolean hasPropsBefore(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.get(propertyId);
            if (propertyValue != null && propertyValue.hasBefore()) continue;
            return false;
        }
        return true;
    }

    private boolean hasPropsAfter(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.get(propertyId);
            if (propertyValue != null && propertyValue.hasAfter()) continue;
            return false;
        }
        return true;
    }

    private Value[] valuesBefore(int[] propertyIds) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            values[i] = ((PropertyValue)this.knownProperties.get(propertyIds[i])).before;
        }
        return values;
    }

    private Value[] valuesAfter(int[] propertyIds) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.get(propertyIds[i]);
            values[i] = propertyValue == null ? null : propertyValue.after;
        }
        return values;
    }

    private boolean valuesChanged(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            if (((PropertyValue)this.knownProperties.get(propertyId)).type != PropertyValueType.Changed) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("[").append(this.nodeId);
        result.append(", labelsBefore:").append(Arrays.toString(this.labelsBefore));
        result.append(", labelsAfter:").append(Arrays.toString(this.labelsAfter));
        this.knownProperties.visitEntries((key, propertyValue) -> {
            result.append(", ");
            result.append(key);
            result.append(" -> ");
            result.append(propertyValue);
            return false;
        });
        return result.append(']').toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.labelsBefore);
        result = 31 * result + Arrays.hashCode(this.labelsAfter);
        result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
        for (int propertyKeyId : this.knownProperties) {
            result = result * 31 + propertyKeyId;
            result = result * 31 + ((PropertyValue)this.knownProperties.get(propertyKeyId)).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeUpdates other = (NodeUpdates)obj;
        return Arrays.equals(this.labelsBefore, other.labelsBefore) && Arrays.equals(this.labelsAfter, other.labelsAfter) && this.nodeId == other.nodeId && this.propertyMapEquals(this.knownProperties, other.knownProperties);
    }

    private boolean propertyMapEquals(PrimitiveIntObjectMap<PropertyValue> a, PrimitiveIntObjectMap<PropertyValue> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int key : a) {
            if (((PropertyValue)a.get(key)).equals(b.get(key))) continue;
            return false;
        }
        return true;
    }

    private static PropertyValue before(Value value) {
        return new PropertyValue(value, null, PropertyValueType.Before);
    }

    private static PropertyValue after(Value value) {
        return new PropertyValue(null, value, PropertyValueType.After);
    }

    private static PropertyValue unchanged(Value value) {
        return new PropertyValue(value, value, PropertyValueType.UnChanged);
    }

    private static PropertyValue changed(Value before, Value after) {
        return new PropertyValue(before, after, PropertyValueType.Changed);
    }

    private static class PropertyValue {
        private final Value before;
        private final Value after;
        private final PropertyValueType type;

        private PropertyValue(Value before, Value after, PropertyValueType type) {
            this.before = before;
            this.after = after;
            this.type = type;
        }

        boolean hasBefore() {
            return this.before != null;
        }

        boolean hasAfter() {
            return this.after != null;
        }

        public String toString() {
            switch (this.type) {
                case NoValue: {
                    return "NoValue";
                }
                case Before: {
                    return String.format("Before(%s)", this.before);
                }
                case After: {
                    return String.format("After(%s)", this.after);
                }
                case UnChanged: {
                    return String.format("UnChanged(%s)", this.after);
                }
                case Changed: {
                    return String.format("Changed(from=%s, to=%s)", this.before, this.after);
                }
            }
            throw new IllegalStateException("This cannot happen!");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (this.type != that.type) {
                return false;
            }
            switch (this.type) {
                case NoValue: {
                    return true;
                }
                case Before: {
                    return this.before.equals(that.before);
                }
                case After: {
                    return this.after.equals(that.after);
                }
                case UnChanged: {
                    return this.after.equals(that.after);
                }
                case Changed: {
                    return this.before.equals(that.before) && this.after.equals(that.after);
                }
            }
            throw new IllegalStateException("This cannot happen!");
        }

        public int hashCode() {
            int result = this.before != null ? this.before.hashCode() : 0;
            result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    static enum PropertyValueType {
        NoValue,
        Before,
        After,
        UnChanged,
        Changed;

    }

    public static class Builder {
        private NodeUpdates updates;

        private Builder(NodeUpdates updates) {
            this.updates = updates;
        }

        public Builder added(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, NodeUpdates.after(value));
            return this;
        }

        public Builder removed(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, NodeUpdates.before(value));
            return this;
        }

        public Builder changed(int propertyKeyId, Value before, Value after) {
            this.updates.put(propertyKeyId, NodeUpdates.changed(before, after));
            return this;
        }

        public Builder existing(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, NodeUpdates.unchanged(value));
            return this;
        }

        public NodeUpdates build() {
            return this.updates;
        }
    }
}

