/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.values.AnyValue;

public class NonTransactionalDbmsOperations
implements DbmsOperations {
    private final Procedures procedures;

    public NonTransactionalDbmsOperations(Procedures procedures) {
        this.procedures = procedures;
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(QualifiedName name, Object[] input, SecurityContext securityContext, ResourceTracker resourceTracker) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        return this.procedures.callProcedure((Context)ctx, name, input, resourceTracker);
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(int id, Object[] input, SecurityContext securityContext, ResourceTracker resourceTracker) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        return this.procedures.callProcedure((Context)ctx, id, input, resourceTracker);
    }

    @Override
    public AnyValue functionCallDbms(QualifiedName name, AnyValue[] input, SecurityContext securityContext) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.SECURITY_CONTEXT, securityContext);
        return this.procedures.callFunction((Context)ctx, name, input);
    }
}

