/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder,
AssertOpen {
    private static final long NOT_COMMITTED_TRANSACTION_ID = -1L;
    private static final long NOT_COMMITTED_TRANSACTION_COMMIT_TIME = -1L;
    private final CollectionsFactory collectionsFactory;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHooks hooks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts statementOperations;
    private final StorageEngine storageEngine;
    private final TransactionTracer transactionTracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final Supplier<ExplicitIndexTransactionState> explicitIndexTxStateSupplier;
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final PageCursorTracerSupplier cursorTracerSupplier;
    private final VersionContextSupplier versionContextSupplier;
    private final StoreReadLayer storeLayer;
    private final ClockContext clocks;
    private final AccessCapability accessCapability;
    private TxState txState;
    private ExplicitIndexTransactionState explicitIndexTransactionState;
    private TransactionWriteState writeState;
    private TransactionHooks.TransactionHooksState hooksState;
    private final KernelStatement currentStatement;
    private final StorageStatement storageStatement;
    private final List<KernelTransaction.CloseListener> closeListeners = new ArrayList<KernelTransaction.CloseListener>(2);
    private SecurityContext securityContext;
    private volatile StatementLocks statementLocks;
    private volatile long userTransactionId;
    private boolean beforeHookInvoked;
    private volatile boolean closing;
    private volatile boolean closed;
    private boolean failure;
    private boolean success;
    private volatile Status terminationReason;
    private long startTimeMillis;
    private long timeoutMillis;
    private long lastTransactionIdWhenStarted;
    private volatile long lastTransactionTimestampWhenStarted;
    private final Statistics statistics;
    private TransactionEvent transactionEvent;
    private Transaction.Type type;
    private long transactionId;
    private long commitTime;
    private volatile int reuseCount;
    private volatile Map<String, Object> userMetaData;
    private final Operations operations;
    private final Lock terminationReleaseLock = new ReentrantLock();

    public KernelTransactionImplementation(StatementOperationParts statementOperations, SchemaWriteGuard schemaWriteGuard, TransactionHooks hooks, ConstraintIndexCreator constraintIndexCreator, Procedures procedures, TransactionHeaderInformationFactory headerInformationFactory, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, Supplier<ExplicitIndexTransactionState> explicitIndexTxStateSupplier, Pool<KernelTransactionImplementation> pool, Clock clock, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef, TransactionTracer transactionTracer, LockTracer lockTracer, PageCursorTracerSupplier cursorTracerSupplier, StorageEngine storageEngine, AccessCapability accessCapability, DefaultCursors cursors, AutoIndexing autoIndexing, ExplicitIndexStore explicitIndexStore, VersionContextSupplier versionContextSupplier, CollectionsFactorySupplier collectionsFactorySupplier, ConstraintSemantics constraintSemantics, SchemaState schemaState) {
        this.statementOperations = statementOperations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.hooks = hooks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.headerInformationFactory = headerInformationFactory;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.storeLayer = storageEngine.storeReadLayer();
        this.storageEngine = storageEngine;
        this.explicitIndexTxStateSupplier = explicitIndexTxStateSupplier;
        this.pool = pool;
        this.clocks = new ClockContext(clock);
        this.transactionTracer = transactionTracer;
        this.cursorTracerSupplier = cursorTracerSupplier;
        this.versionContextSupplier = versionContextSupplier;
        this.storageStatement = this.storeLayer.newStatement();
        this.currentStatement = new KernelStatement(this, this, this.storageStatement, procedures, accessCapability, lockTracer, statementOperations, this.clocks, versionContextSupplier);
        this.accessCapability = accessCapability;
        this.statistics = new Statistics(this, cpuClockRef, heapAllocationRef);
        this.userMetaData = new HashMap<String, Object>();
        AllStoreHolder allStoreHolder = new AllStoreHolder(storageEngine, this.storageStatement, this, cursors, explicitIndexStore, procedures, schemaState);
        this.operations = new Operations(allStoreHolder, new IndexTxStateUpdater(storageEngine.storeReadLayer(), allStoreHolder), this.storageStatement, this, new KernelToken(this.storeLayer, this), cursors, autoIndexing, constraintIndexCreator, constraintSemantics);
        this.collectionsFactory = collectionsFactorySupplier.create();
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, long lastTimeStamp, StatementLocks statementLocks, Transaction.Type type, SecurityContext frozenSecurityContext, long transactionTimeout, long userTransactionId) {
        this.type = type;
        this.statementLocks = statementLocks;
        this.userTransactionId = userTransactionId;
        this.terminationReason = null;
        this.closing = false;
        this.closed = false;
        this.beforeHookInvoked = false;
        this.failure = false;
        this.success = false;
        this.writeState = TransactionWriteState.NONE;
        this.startTimeMillis = this.clocks.systemClock().millis();
        this.timeoutMillis = transactionTimeout;
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.lastTransactionTimestampWhenStarted = lastTimeStamp;
        this.transactionEvent = this.transactionTracer.beginTransaction();
        assert (this.transactionEvent != null) : "transactionEvent was null!";
        this.securityContext = frozenSecurityContext;
        this.transactionId = -1L;
        this.commitTime = -1L;
        PageCursorTracer pageCursorTracer = (PageCursorTracer)this.cursorTracerSupplier.get();
        this.statistics.init(Thread.currentThread().getId(), pageCursorTracer);
        this.currentStatement.initialize(statementLocks, pageCursorTracer);
        this.operations.initialize();
        return this;
    }

    int getReuseCount() {
        return this.reuseCount;
    }

    @Override
    public long startTime() {
        return this.startTimeMillis;
    }

    @Override
    public long timeout() {
        return this.timeoutMillis;
    }

    @Override
    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    public void success() {
        this.success = true;
    }

    boolean isSuccess() {
        return this.success;
    }

    public void failure() {
        this.failure = true;
    }

    @Override
    public Optional<Status> getReasonIfTerminated() {
        return Optional.ofNullable(this.terminationReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markForTermination(long expectedReuseCount, Status reason) {
        this.terminationReleaseLock.lock();
        try {
            boolean bl = expectedReuseCount == (long)this.reuseCount && this.markForTerminationIfPossible(reason);
            return bl;
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    @Override
    public void markForTermination(Status reason) {
        this.terminationReleaseLock.lock();
        try {
            this.markForTerminationIfPossible(reason);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean markForTerminationIfPossible(Status reason) {
        if (this.canBeTerminated()) {
            this.failure = true;
            this.terminationReason = reason;
            if (this.statementLocks != null) {
                this.statementLocks.stop();
            }
            this.transactionMonitor.transactionTerminated(this.hasTxStateWithChanges());
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    public void setMetaData(Map<String, Object> data) {
        this.userMetaData = data;
    }

    public Map<String, Object> getMetaData() {
        return this.userMetaData;
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertTransactionOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    ExecutingQueryList executingQueries() {
        return this.currentStatement.executingQueryList();
    }

    void upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
        this.writeState = this.writeState.upgradeToDataWrites();
    }

    void upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
        this.schemaWriteGuard.assertSchemaWritesAllowed();
        this.writeState = this.writeState.upgradeToSchemaWrites();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (SchemaIndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState(this.collectionsFactory);
        }
        return this.txState;
    }

    @Override
    public ExplicitIndexTransactionState explicitIndexTxState() {
        return this.explicitIndexTransactionState != null ? this.explicitIndexTransactionState : (this.explicitIndexTransactionState = this.explicitIndexTxStateSupplier.get());
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void markAsClosed(long txId) {
        this.assertTransactionOpen();
        this.closed = true;
        this.notifyListeners(txId);
        this.closeCurrentStatementIfAny();
    }

    private void notifyListeners(long txId) {
        for (KernelTransaction.CloseListener closeListener : this.closeListeners) {
            closeListener.notify(txId);
        }
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    @Override
    public void assertOpen() {
        Status reason = this.terminationReason;
        if (reason != null) {
            throw new TransactionTerminatedException(reason);
        }
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges() || this.hasExplicitIndexChanges();
    }

    private boolean hasExplicitIndexChanges() {
        return this.explicitIndexTransactionState != null && this.explicitIndexTransactionState.hasChanges();
    }

    private boolean hasDataChanges() {
        return this.hasTxStateWithChanges() && this.txState.hasDataChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long closeTransaction() throws TransactionFailureException {
        block12: {
            long l;
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closing = true;
            try {
                if (!this.failure && this.success && !this.isTerminated()) break block12;
                this.rollback();
                this.failOnNonExplicitRollbackIfNeeded();
                l = -1L;
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionWriteState(this.writeState.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                }
                finally {
                    this.release();
                }
                throw throwable;
            }
            try {
                this.closed = true;
                this.closing = false;
                this.transactionEvent.setSuccess(this.success);
                this.transactionEvent.setFailure(this.failure);
                this.transactionEvent.setTransactionWriteState(this.writeState.name());
                this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                this.transactionEvent.close();
            }
            finally {
                this.release();
            }
            return l;
        }
        long l = this.commit();
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionWriteState(this.writeState.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
        }
        finally {
            this.release();
        }
        return l;
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.success && this.isTerminated()) {
            throw new TransactionTerminatedException(this.terminationReason);
        }
        if (this.success) {
            throw new TransactionFailureException((Status)Status.Transaction.TransactionMarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private long commit() throws TransactionFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rollback() throws TransactionFailureException {
        block7: {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                catch (IllegalStateException | SecurityException e) {
                    throw new TransactionFailureException((Status)Status.Transaction.TransactionRollbackFailed, e, "Could not drop created constraint indexes", new Object[0]);
                }
                if (this.txState == null) break block7;
                try {
                    this.txState.accept(new TxStateVisitor.Adapter(){

                        @Override
                        public void visitCreatedNode(long id) {
                            KernelTransactionImplementation.this.storeLayer.releaseNode(id);
                        }

                        @Override
                        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                            KernelTransactionImplementation.this.storeLayer.releaseRelationship(id);
                        }
                    });
                }
                catch (ConstraintValidationException | CreateConstraintFailureException e) {
                    throw new IllegalStateException("Releasing locks during rollback should perform no constraints checking.", (Throwable)e);
                }
            }
            finally {
                this.afterRollback();
            }
        }
    }

    public Read dataRead() {
        this.currentStatement.assertAllows(AccessMode::allowsReads, "Read");
        return this.operations.dataRead();
    }

    public Read stableDataRead() {
        this.currentStatement.assertAllows(AccessMode::allowsReads, "Read");
        return this.operations.dataRead();
    }

    public void markAsStable() {
    }

    public Write dataWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.currentStatement.assertAllows(AccessMode::allowsWrites, "Write");
        this.upgradeToDataWrites();
        return this.operations;
    }

    public TokenWrite tokenWrite() {
        this.currentStatement.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public Token token() {
        this.currentStatement.assertAllows(AccessMode::allowsTokenCreates, "Token create");
        this.accessCapability.assertCanWrite();
        return this.operations.token();
    }

    public TokenRead tokenRead() {
        this.currentStatement.assertAllows(AccessMode::allowsReads, "Read");
        return this.operations.token();
    }

    public ExplicitIndexRead indexRead() {
        this.currentStatement.assertAllows(AccessMode::allowsReads, "Read");
        return this.operations.indexRead();
    }

    public ExplicitIndexWrite indexWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.currentStatement.assertAllows(AccessMode::allowsWrites, "Write");
        this.upgradeToDataWrites();
        return this.operations;
    }

    public SchemaRead schemaRead() {
        this.currentStatement.assertAllows(AccessMode::allowsReads, "Read");
        return this.operations.schemaRead();
    }

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
        this.accessCapability.assertCanWrite();
        this.currentStatement.assertAllows(AccessMode::allowsSchemaWrites, "Schema");
        this.upgradeToSchemaWrites();
        return this.operations;
    }

    public Locks locks() {
        return this.operations.locks();
    }

    public StatementLocks statementLocks() {
        return this.statementLocks;
    }

    public CursorFactory cursors() {
        return this.operations.cursors();
    }

    public org.neo4j.internal.kernel.api.Procedures procedures() {
        return this.operations.procedures();
    }

    public LockTracer lockTracer() {
        return this.currentStatement.lockTracer();
    }

    private void afterCommit(long txId) {
        try {
            this.markAsClosed(txId);
            if (this.beforeHookInvoked) {
                this.hooks.afterCommit(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxStateWithChanges());
        }
    }

    private void afterRollback() {
        try {
            this.markAsClosed(-1L);
            if (this.beforeHookInvoked) {
                this.hooks.afterRollback(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxStateWithChanges());
        }
    }

    private void release() {
        this.terminationReleaseLock.lock();
        try {
            this.statementLocks.close();
            this.statementLocks = null;
            this.terminationReason = null;
            this.type = null;
            this.securityContext = null;
            this.transactionEvent = null;
            this.explicitIndexTransactionState = null;
            if (this.txState != null) {
                this.txState.release();
                this.txState = null;
            }
            this.hooksState = null;
            this.closeListeners.clear();
            ++this.reuseCount;
            this.userMetaData = Collections.emptyMap();
            this.userTransactionId = 0L;
            this.statistics.reset();
            this.operations.release();
            this.pool.release((Object)this);
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    @Override
    public boolean isTerminated() {
        return this.terminationReason != null;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    @Override
    public void registerCloseListener(KernelTransaction.CloseListener listener) {
        assert (listener != null);
        this.closeListeners.add(listener);
    }

    @Override
    public Transaction.Type transactionType() {
        return this.type;
    }

    @Override
    public long getTransactionId() {
        if (this.transactionId == -1L) {
            throw new IllegalStateException("Transaction id is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.transactionId;
    }

    @Override
    public long getCommitTime() {
        if (this.commitTime == -1L) {
            throw new IllegalStateException("Transaction commit time is not assigned yet. It will be assigned during transaction commit.");
        }
        return this.commitTime;
    }

    @Override
    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        SecurityContext oldContext = this.securityContext;
        this.securityContext = context;
        return () -> {
            this.securityContext = oldContext;
        };
    }

    public String toString() {
        String lockSessionId = this.statementLocks == null ? "statementLocks == null" : String.valueOf(this.statementLocks.pessimistic().getLockSessionId());
        return "KernelTransaction[" + lockSessionId + "]";
    }

    public void dispose() {
        this.storageStatement.close();
    }

    public Stream<? extends ActiveLock> activeLocks() {
        StatementLocks locks = this.statementLocks;
        return locks == null ? Stream.empty() : locks.activeLocks();
    }

    long userTransactionId() {
        return this.userTransactionId;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public ClockContext clocks() {
        return this.clocks;
    }

    @Override
    public NodeCursor nodeCursor() {
        return this.operations.nodeCursor();
    }

    @Override
    public RelationshipScanCursor relationshipCursor() {
        return this.operations.relationshipCursor();
    }

    @Override
    public PropertyCursor propertyCursor() {
        return this.operations.propertyCursor();
    }

    private static enum TransactionWriteState {
        NONE,
        DATA{

            @Override
            TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionWriteState upgradeToDataWrites() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionWriteState upgradeToSchemaWrites() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }

    public static class Statistics {
        private volatile long cpuTimeNanosWhenQueryStarted;
        private volatile long heapAllocatedBytesWhenQueryStarted;
        private volatile long waitingTimeNanos;
        private volatile long transactionThreadId;
        private volatile PageCursorTracer pageCursorTracer = PageCursorTracer.NULL;
        private final KernelTransactionImplementation transaction;
        private final AtomicReference<CpuClock> cpuClockRef;
        private final AtomicReference<HeapAllocation> heapAllocationRef;
        private CpuClock cpuClock;
        private HeapAllocation heapAllocation;

        public Statistics(KernelTransactionImplementation transaction, AtomicReference<CpuClock> cpuClockRef, AtomicReference<HeapAllocation> heapAllocationRef) {
            this.transaction = transaction;
            this.cpuClockRef = cpuClockRef;
            this.heapAllocationRef = heapAllocationRef;
        }

        protected void init(long threadId, PageCursorTracer pageCursorTracer) {
            this.cpuClock = this.cpuClockRef.get();
            this.heapAllocation = this.heapAllocationRef.get();
            this.transactionThreadId = threadId;
            this.pageCursorTracer = pageCursorTracer;
            this.cpuTimeNanosWhenQueryStarted = this.cpuClock.cpuTimeNanos(this.transactionThreadId);
            this.heapAllocatedBytesWhenQueryStarted = this.heapAllocation.allocatedBytes(this.transactionThreadId);
        }

        long heapAllocatedBytes() {
            return this.heapAllocation.allocatedBytes(this.transactionThreadId) - this.heapAllocatedBytesWhenQueryStarted;
        }

        long directAllocatedBytes() {
            return this.transaction.collectionsFactory.getMemoryTracker().usedDirectMemory();
        }

        public long cpuTimeMillis() {
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.transactionThreadId) - this.cpuTimeNanosWhenQueryStarted;
            return TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos);
        }

        long totalTransactionPageCacheHits() {
            return this.pageCursorTracer.accumulatedHits();
        }

        long totalTransactionPageCacheFaults() {
            return this.pageCursorTracer.accumulatedFaults();
        }

        void addWaitingTime(long waitTimeNanos) {
            this.waitingTimeNanos += waitTimeNanos;
        }

        long getWaitingTimeNanos(long nowNanos) {
            ExecutingQueryList queryList = this.transaction.executingQueries();
            long waitingTime = this.waitingTimeNanos;
            if (queryList != null) {
                Long latestQueryWaitingNanos = queryList.top(executingQuery -> executingQuery.totalWaitingTimeNanos(nowNanos));
                waitingTime = latestQueryWaitingNanos != null ? waitingTime + latestQueryWaitingNanos : waitingTime;
            }
            return waitingTime;
        }

        void reset() {
            this.pageCursorTracer = PageCursorTracer.NULL;
            this.cpuTimeNanosWhenQueryStarted = 0L;
            this.heapAllocatedBytesWhenQueryStarted = 0L;
            this.waitingTimeNanos = 0L;
            this.transactionThreadId = -1L;
        }
    }
}

