/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.storageengine.api.lock.ResourceType;

class WaitingOnLock
extends ExecutingQueryStatus {
    private final String mode;
    private final ResourceType resourceType;
    private final long[] resourceIds;
    private final long startTimeNanos;

    WaitingOnLock(String mode, ResourceType resourceType, long[] resourceIds, long startTimeNanos) {
        this.mode = mode;
        this.resourceType = resourceType;
        this.resourceIds = resourceIds;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    long waitTimeNanos(long currentTimeNanos) {
        return currentTimeNanos - this.startTimeNanos;
    }

    @Override
    Map<String, Object> toMap(long currentTimeNanos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lockMode", this.mode);
        map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(currentTimeNanos)));
        map.put("resourceType", this.resourceType.toString());
        map.put("resourceIds", this.resourceIds);
        return map;
    }

    @Override
    String name() {
        return "waiting";
    }

    @Override
    boolean isWaitingOnLocks() {
        return true;
    }

    @Override
    List<ActiveLock> waitingOnLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        switch (this.mode) {
            case "EXCLUSIVE": {
                for (long resourceId : this.resourceIds) {
                    locks.add(ActiveLock.exclusiveLock(this.resourceType, resourceId));
                }
                break;
            }
            case "SHARED": {
                for (long resourceId : this.resourceIds) {
                    locks.add(ActiveLock.sharedLock(this.resourceType, resourceId));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type of lock mode: " + this.mode);
            }
        }
        return locks;
    }
}

