/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.util.concurrent.ThreadFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;

public class FileWatcherLifecycleAdapter
extends LifecycleAdapter {
    private final JobScheduler jobScheduler;
    private final FileWatcher fileWatcher;
    private final FileSystemEventWatcher eventWatcher;
    private ThreadFactory fileWatchers;
    private Thread watcher;

    public FileWatcherLifecycleAdapter(JobScheduler jobScheduler, FileWatcher fileWatcher) {
        this.jobScheduler = jobScheduler;
        this.fileWatcher = fileWatcher;
        this.eventWatcher = new FileSystemEventWatcher();
    }

    public void init() {
        this.fileWatchers = this.jobScheduler.threadFactory(JobScheduler.Groups.fileWatch);
    }

    public void start() {
        this.watcher = this.fileWatchers.newThread(this.eventWatcher);
        this.watcher.start();
    }

    public void stop() throws Throwable {
        this.eventWatcher.stopWatching();
        if (this.watcher != null) {
            this.watcher.interrupt();
            this.watcher.join();
            this.watcher = null;
        }
    }

    public void shutdown() throws Throwable {
        this.fileWatcher.close();
    }

    private class FileSystemEventWatcher
    implements Runnable {
        private FileSystemEventWatcher() {
        }

        @Override
        public void run() {
            try {
                FileWatcherLifecycleAdapter.this.fileWatcher.startWatching();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void stopWatching() {
            FileWatcherLifecycleAdapter.this.fileWatcher.stopWatching();
        }
    }
}

