/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class DefaultCheckPointerTracer
implements CheckPointTracer,
CheckPointerMonitor {
    private final SystemNanoClock clock;
    private final Monitor monitor;
    private final JobScheduler jobScheduler;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong accumulatedTotalTimeNanos = new AtomicLong();
    private volatile long startTimeNanos;
    private LogCheckPointEvent logCheckPointEvent = new LogCheckPointEvent(){

        @Override
        public void close() {
            DefaultCheckPointerTracer.this.updateCountersAndNotifyListeners();
        }

        @Override
        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        @Override
        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    };

    public DefaultCheckPointerTracer(Monitor monitor, JobScheduler jobScheduler) {
        this(Clocks.nanoClock(), monitor, jobScheduler);
    }

    public DefaultCheckPointerTracer(SystemNanoClock clock, Monitor monitor, JobScheduler jobScheduler) {
        this.clock = clock;
        this.monitor = monitor;
        this.jobScheduler = jobScheduler;
    }

    @Override
    public LogCheckPointEvent beginCheckPoint() {
        this.startTimeNanos = this.clock.nanos();
        return this.logCheckPointEvent;
    }

    @Override
    public long numberOfCheckPointEvents() {
        return this.counter.get();
    }

    @Override
    public long checkPointAccumulatedTotalTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.accumulatedTotalTimeNanos.get());
    }

    private void updateCountersAndNotifyListeners() {
        long lastEventTime = this.clock.nanos() - this.startTimeNanos;
        this.counter.incrementAndGet();
        this.accumulatedTotalTimeNanos.addAndGet(lastEventTime);
        this.jobScheduler.schedule(JobScheduler.Groups.metricsEvent, () -> {
            long millis = TimeUnit.NANOSECONDS.toMillis(lastEventTime);
            this.monitor.lastCheckPointEventDuration(millis);
        });
    }

    public static interface Monitor {
        public void lastCheckPointEventDuration(long var1);
    }
}

