/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.IOException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

abstract class StoreScanAsInputIterator<RECORD extends AbstractBaseRecord>
implements InputIterator {
    private final RecordStore<RECORD> store;
    private final int batchSize;
    private final long highId;
    private long id;

    StoreScanAsInputIterator(RecordStore<RECORD> store) {
        this.store = store;
        this.batchSize = store.getRecordsPerPage() * 10;
        this.highId = store.getHighId();
    }

    @Override
    public InputChunk newChunk() {
        RecordCursor<RECORD> cursor = this.store.newRecordCursor(this.store.newRecord()).acquire(0L, RecordLoad.CHECK);
        return new StoreScanChunk(cursor);
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized boolean next(InputChunk chunk) {
        if (this.id >= this.highId) {
            return false;
        }
        long startId = this.id;
        this.id = Long.min(this.highId, startId + (long)this.batchSize);
        ((StoreScanChunk)chunk).initialize(startId, this.id);
        return true;
    }

    protected abstract boolean visitRecord(RECORD var1, InputEntityVisitor var2);

    private class StoreScanChunk
    implements InputChunk {
        private final RecordCursor<RECORD> cursor;
        private long id;
        private long endId;

        StoreScanChunk(RecordCursor<RECORD> cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean next(InputEntityVisitor visitor) throws IOException {
            if (this.id < this.endId) {
                if (this.cursor.next(this.id)) {
                    StoreScanAsInputIterator.this.visitRecord((AbstractBaseRecord)this.cursor.get(), visitor);
                    visitor.endOfEntity();
                }
                ++this.id;
                return true;
            }
            return false;
        }

        public void initialize(long startId, long endId) {
            this.id = startId;
            this.endId = endId;
        }

        @Override
        public void close() {
            this.cursor.close();
        }
    }
}

