/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a DateTime instant.")
class DateTimeFunction
extends TemporalFunction<DateTimeValue> {
    DateTimeFunction() {
        super(Neo4jTypes.NTDateTime);
    }

    @Override
    protected DateTimeValue now(Clock clock, String timezone) {
        return timezone == null ? DateTimeValue.now((Clock)clock) : DateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected DateTimeValue positionalCreate(AnyValue[] input) {
        if (input.length != 8) {
            throw new IllegalArgumentException("expected 8 arguments");
        }
        return DateTimeValue.datetime((int)DateTimeFunction.anInt("year", input[0]), (int)DateTimeFunction.anInt("month", input[1]), (int)DateTimeFunction.anInt("day", input[2]), (int)DateTimeFunction.anInt("hour", input[3]), (int)DateTimeFunction.anInt("minute", input[4]), (int)DateTimeFunction.anInt("second", input[5]), (int)DateTimeFunction.anInt("nanos", input[6]), (String)DateTimeFunction.aString("timezone", input[7]));
    }

    @Override
    protected DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    void registerMore(Procedures procedures) throws ProcedureException {
        procedures.register(new FromEpoch());
        procedures.register(new FromEpochMillis());
    }

    private static class FromEpochMillis
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the milliseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField("milliseconds", Neo4jTypes.NTInteger));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepochmillis"), SIGNATURE, Neo4jTypes.NTDateTime, Optional.empty(), new String[0], Optional.of("Create a DateTime given the milliseconds since the start of the epoch."));

        private FromEpochMillis() {
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 1 && input[0] instanceof IntegralValue) {
                IntegralValue milliseconds = (IntegralValue)input[0];
                return DateTimeValue.ofEpochMillis((IntegralValue)milliseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature", new Object[0]);
        }
    }

    private static class FromEpoch
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the seconds and nanoseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField("seconds", Neo4jTypes.NTInteger), FieldSignature.inputField("nanoseconds", Neo4jTypes.NTInteger));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepoch"), SIGNATURE, Neo4jTypes.NTDateTime, Optional.empty(), new String[0], Optional.of("Create a DateTime given the seconds and nanoseconds since the start of the epoch."));

        private FromEpoch() {
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input) throws ProcedureException {
            if (input != null && input.length == 2 && input[0] instanceof IntegralValue && input[1] instanceof IntegralValue) {
                IntegralValue seconds = (IntegralValue)input[0];
                IntegralValue nanoseconds = (IntegralValue)input[1];
                return DateTimeValue.ofEpoch((IntegralValue)seconds, (IntegralValue)nanoseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature", new Object[0]);
        }
    }
}

