/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
implements IndexReader {
    private final IndexReader numberReader;
    private final IndexReader spatialReader;
    private final IndexReader temporalReader;
    private final IndexReader luceneReader;
    private final FusionSchemaIndexProvider.Selector selector;
    private final IndexDescriptor descriptor;

    FusionIndexReader(IndexReader numberReader, IndexReader spatialReader, IndexReader temporalReader, IndexReader luceneReader, FusionSchemaIndexProvider.Selector selector, IndexDescriptor descriptor) {
        this.numberReader = numberReader;
        this.spatialReader = spatialReader;
        this.temporalReader = temporalReader;
        this.luceneReader = luceneReader;
        this.selector = selector;
        this.descriptor = descriptor;
    }

    public void close() {
        FusionIndexUtils.forAll(Resource::close, this.numberReader, this.spatialReader, this.temporalReader, this.luceneReader);
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return this.selector.select(this.numberReader, this.spatialReader, this.temporalReader, this.luceneReader, propertyValues).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.numberReader.createSampler(), this.spatialReader.createSampler(), this.temporalReader.createSampler(), this.luceneReader.createSampler());
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            return this.luceneReader.query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicates[0];
            return this.selector.select(this.numberReader, this.spatialReader, this.temporalReader, this.luceneReader, exactPredicate.value()).query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            return this.numberReader.query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.GeometryRangePredicate) {
            return this.spatialReader.query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            PrimitiveLongResourceIterator numberResult = this.numberReader.query(predicates);
            PrimitiveLongResourceIterator spatialResult = this.spatialReader.query(predicates);
            PrimitiveLongResourceIterator temporalResult = this.temporalReader.query(predicates);
            PrimitiveLongResourceIterator luceneResult = this.luceneReader.query(predicates);
            return PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])new PrimitiveLongResourceIterator[]{numberResult, spatialResult, temporalResult, luceneResult});
        }
        return this.luceneReader.query(predicates);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            this.luceneReader.query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicates[0];
            this.selector.select(this.numberReader, this.spatialReader, this.temporalReader, this.luceneReader, exactPredicate.value()).query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            this.numberReader.query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.GeometryRangePredicate) {
            this.spatialReader.query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            this.numberReader.query(multiProgressor, indexOrder, predicates);
            this.spatialReader.query(multiProgressor, indexOrder, predicates);
            this.temporalReader.query(multiProgressor, indexOrder, predicates);
            this.luceneReader.query(multiProgressor, indexOrder, predicates);
            return;
        }
        this.luceneReader.query(cursor, indexOrder, predicates);
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return false;
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            Value value = ((IndexQuery.ExactPredicate)predicate).value();
            return this.selector.select(this.numberReader.hasFullValuePrecision(predicates), this.spatialReader.hasFullValuePrecision(predicates), this.temporalReader.hasFullValuePrecision(predicates), this.luceneReader.hasFullValuePrecision(predicates), value);
        }
        if (predicate instanceof IndexQuery.NumberRangePredicate) {
            return this.numberReader.hasFullValuePrecision(predicates);
        }
        return false;
    }
}

