/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexSample;

class FusionIndexPopulator
implements IndexPopulator {
    private final IndexPopulator numberPopulator;
    private final IndexPopulator spatialPopulator;
    private final IndexPopulator temporalPopulator;
    private final IndexPopulator lucenePopulator;
    private final FusionSchemaIndexProvider.Selector selector;
    private final long indexId;
    private final FusionSchemaIndexProvider.DropAction dropAction;

    FusionIndexPopulator(IndexPopulator numberPopulator, IndexPopulator spatialPopulator, IndexPopulator temporalPopulator, IndexPopulator lucenePopulator, FusionSchemaIndexProvider.Selector selector, long indexId, FusionSchemaIndexProvider.DropAction dropAction) {
        this.numberPopulator = numberPopulator;
        this.spatialPopulator = spatialPopulator;
        this.temporalPopulator = temporalPopulator;
        this.lucenePopulator = lucenePopulator;
        this.selector = selector;
        this.indexId = indexId;
        this.dropAction = dropAction;
    }

    @Override
    public void create() throws IOException {
        this.numberPopulator.create();
        this.spatialPopulator.create();
        this.temporalPopulator.create();
        this.lucenePopulator.create();
    }

    @Override
    public void drop() throws IOException {
        FusionIndexUtils.forAll(IndexPopulator::drop, this.numberPopulator, this.spatialPopulator, this.temporalPopulator, this.lucenePopulator);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        ArrayList luceneBatch = new ArrayList();
        ArrayList spatialBatch = new ArrayList();
        ArrayList temporalBatch = new ArrayList();
        ArrayList numberBatch = new ArrayList();
        for (IndexEntryUpdate<?> update : updates) {
            ((Collection)this.selector.select(numberBatch, spatialBatch, temporalBatch, luceneBatch, update.values())).add(update);
        }
        this.lucenePopulator.add(luceneBatch);
        this.spatialPopulator.add(spatialBatch);
        this.temporalPopulator.add(temporalBatch);
        this.numberPopulator.add(numberBatch);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.numberPopulator.verifyDeferredConstraints(propertyAccessor);
        this.spatialPopulator.verifyDeferredConstraints(propertyAccessor);
        this.temporalPopulator.verifyDeferredConstraints(propertyAccessor);
        this.lucenePopulator.verifyDeferredConstraints(propertyAccessor);
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new FusionIndexUpdater(this.numberPopulator.newPopulatingUpdater(accessor), this.spatialPopulator.newPopulatingUpdater(accessor), this.temporalPopulator.newPopulatingUpdater(accessor), this.lucenePopulator.newPopulatingUpdater(accessor), this.selector);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        FusionIndexUtils.forAll(populator -> populator.close(populationCompletedSuccessfully), this.numberPopulator, this.spatialPopulator, this.temporalPopulator, this.lucenePopulator);
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        FusionIndexUtils.forAll(populator -> populator.markAsFailed(failure), this.numberPopulator, this.spatialPopulator, this.temporalPopulator, this.lucenePopulator);
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.selector.select(this.numberPopulator, this.spatialPopulator, this.temporalPopulator, this.lucenePopulator, update.values()).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionSchemaIndexProvider.combineSamples(this.numberPopulator.sampleResult(), this.spatialPopulator.sampleResult(), this.temporalPopulator.sampleResult(), this.lucenePopulator.sampleResult());
    }
}

