/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DateSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexFiles {
    private final FileSystemAbstraction fs;
    private FileLayout<DateSchemaKey> dateFileLayout;
    private FileLayout dateTimeFileLayout;
    private FileLayout dateTimeZonedFileLayout;
    private FileLayout timeFileLayout;
    private FileLayout timeZonedFileLayout;
    private FileLayout durationFileLayout;

    TemporalIndexFiles(IndexDirectoryStructure directoryStructure, long indexId, IndexDescriptor descriptor, FileSystemAbstraction fs) {
        this.fs = fs;
        File indexDirectory = directoryStructure.directoryForIndex(indexId);
        this.dateFileLayout = new FileLayout<DateSchemaKey>(new File(indexDirectory, "date"), DateLayout.of(descriptor), ValueGroup.DATE);
    }

    Iterable<FileLayout> existing() {
        ArrayList<FileLayout> existing = new ArrayList<FileLayout>();
        this.addIfExists(existing, this.dateFileLayout);
        this.addIfExists(existing, this.dateTimeFileLayout);
        this.addIfExists(existing, this.dateTimeZonedFileLayout);
        this.addIfExists(existing, this.timeFileLayout);
        this.addIfExists(existing, this.timeZonedFileLayout);
        this.addIfExists(existing, this.durationFileLayout);
        return existing;
    }

    <T, E extends Exception> void loadExistingIndexes(TemporalIndexCache<T, E> indexCache) throws E {
        for (FileLayout fileLayout : this.existing()) {
            indexCache.select(fileLayout.valueGroup);
        }
    }

    private void addIfExists(List<FileLayout> existing, FileLayout fileLayout) {
        if (this.exists(fileLayout)) {
            existing.add(fileLayout);
        }
    }

    private boolean exists(FileLayout fileLayout) {
        return fileLayout != null && this.fs.fileExists(fileLayout.indexFile);
    }

    public FileLayout<DateSchemaKey> date() {
        return this.dateFileLayout;
    }

    static class FileLayout<KEY extends NativeSchemaKey> {
        final File indexFile;
        final Layout<KEY, NativeSchemaValue> layout;
        final ValueGroup valueGroup;

        FileLayout(File indexFile, Layout<KEY, NativeSchemaValue> layout, ValueGroup valueGroup) {
            this.indexFile = indexFile;
            this.layout = layout;
            this.valueGroup = valueGroup;
        }
    }
}

