/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeNonUniqueSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexes;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NativeUniqueSchemaIndexPopulator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

abstract class NativeSchemaIndexProvider<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
extends SchemaIndexProvider {
    protected final PageCache pageCache;
    protected final FileSystemAbstraction fs;
    protected final SchemaIndexProvider.Monitor monitor;
    protected final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    protected final boolean readOnly;

    protected NativeSchemaIndexProvider(SchemaIndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, SchemaIndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(descriptor, priority, directoryStructureFactory);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        switch (descriptor.type()) {
            case GENERAL: {
                return new NativeNonUniqueSchemaIndexPopulator<KEY, VALUE>(this.pageCache, this.fs, storeFile, this.layoutNonUnique(), samplingConfig, this.monitor, descriptor, indexId);
            }
            case UNIQUE: {
                return new NativeUniqueSchemaIndexPopulator<KEY, VALUE>(this.pageCache, this.fs, storeFile, this.layoutUnique(), this.monitor, descriptor, indexId);
            }
        }
        throw new UnsupportedOperationException("Can not create index populator of type " + (Object)((Object)descriptor.type()));
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        Layout<KEY, VALUE> layout = this.layout(descriptor);
        return this.newIndexAccessor(storeFile, layout, descriptor, indexId, samplingConfig);
    }

    protected abstract IndexAccessor newIndexAccessor(File var1, Layout<KEY, VALUE> var2, IndexDescriptor var3, long var4, IndexSamplingConfig var6) throws IOException;

    @Override
    public String getPopulationFailure(long indexId, IndexDescriptor descriptor) throws IllegalStateException {
        try {
            String failureMessage = NativeSchemaIndexes.readFailureMessage(this.pageCache, this.nativeIndexFileFromIndexId(indexId), this.layout(descriptor));
            if (failureMessage == null) {
                throw new IllegalStateException("Index " + indexId + " isn't failed");
            }
            return failureMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        try {
            return NativeSchemaIndexes.readState(this.pageCache, this.nativeIndexFileFromIndexId(indexId), this.layout(descriptor));
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", e);
            return InternalIndexState.POPULATING;
        }
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private Layout<KEY, VALUE> layout(IndexDescriptor descriptor) {
        switch (descriptor.type()) {
            case GENERAL: {
                return this.layoutNonUnique();
            }
            case UNIQUE: {
                return this.layoutUnique();
            }
        }
        throw new UnsupportedOperationException("Can not create index accessor of type " + (Object)((Object)descriptor.type()));
    }

    protected abstract Layout<KEY, VALUE> layoutUnique();

    protected abstract Layout<KEY, VALUE> layoutNonUnique();

    private File nativeIndexFileFromIndexId(long indexId) {
        return new File(this.directoryStructure().directoryForIndex(indexId), NativeSchemaIndexProvider.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }
}

