/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.DateSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;

abstract class DateLayout
extends Layout.Adapter<DateSchemaKey, NativeSchemaValue> {
    private static final long UNIQUE_LAYOUT_IDENTIFIER = Layout.namedIdentifier((String)"UTda", (int)0);
    public static DateLayout UNIQUE = new DateLayout(){

        public long identifier() {
            return UNIQUE_LAYOUT_IDENTIFIER;
        }

        public int majorVersion() {
            return 0;
        }

        public int minorVersion() {
            return 1;
        }

        public int compare(DateSchemaKey o1, DateSchemaKey o2) {
            int comparison = o1.compareValueTo(o2);
            return comparison != 0 ? comparison : Long.compare(o1.getEntityId(), o2.getEntityId());
        }
    };
    private static final long NON_UNIQUE_LAYOUT_IDENTIFIER = Layout.namedIdentifier((String)"NTda", (int)0);
    public static DateLayout NON_UNIQUE = new DateLayout(){

        public long identifier() {
            return NON_UNIQUE_LAYOUT_IDENTIFIER;
        }

        public int majorVersion() {
            return 0;
        }

        public int minorVersion() {
            return 1;
        }

        public int compare(DateSchemaKey o1, DateSchemaKey o2) {
            int comparison = o1.compareValueTo(o2);
            if (comparison == 0 && (o1.getCompareId() || o2.getCompareId())) {
                return Long.compare(o1.getEntityId(), o2.getEntityId());
            }
            return comparison;
        }
    };

    DateLayout() {
    }

    public static Layout<DateSchemaKey, NativeSchemaValue> of(IndexDescriptor descriptor) {
        return descriptor.type() == IndexDescriptor.Type.UNIQUE ? UNIQUE : NON_UNIQUE;
    }

    public DateSchemaKey newKey() {
        return new DateSchemaKey();
    }

    public DateSchemaKey copyKey(DateSchemaKey key, DateSchemaKey into) {
        into.epochDay = key.epochDay;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public NativeSchemaValue newValue() {
        return NativeSchemaValue.INSTANCE;
    }

    public int keySize(DateSchemaKey key) {
        return 16;
    }

    public int valueSize(NativeSchemaValue value) {
        return 0;
    }

    public void writeKey(PageCursor cursor, DateSchemaKey key) {
        cursor.putLong(key.epochDay);
        cursor.putLong(key.getEntityId());
    }

    public void writeValue(PageCursor cursor, NativeSchemaValue value) {
    }

    public void readKey(PageCursor cursor, DateSchemaKey into, int keySize) {
        into.epochDay = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }

    public void readValue(PageCursor cursor, NativeSchemaValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return true;
    }
}

