/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class GraphPropertiesProxy
implements GraphProperties {
    private final EmbeddedProxySPI actions;

    public GraphPropertiesProxy(EmbeddedProxySPI actions) {
        this.actions = actions;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabase();
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        PropertyCursor properties = transaction.propertyCursor();
        transaction.dataRead().graphProperties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            return true;
        }
        return false;
    }

    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        PropertyCursor properties = transaction.propertyCursor();
        transaction.dataRead().graphProperties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            if (value == Values.NO_VALUE) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            return value.asObjectCopy();
        }
        throw new NotFoundException(String.format("No such property, '%s'.", key));
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        PropertyCursor properties = transaction.propertyCursor();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        transaction.dataRead().graphProperties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            return value == Values.NO_VALUE ? defaultValue : value.asObjectCopy();
        }
        return defaultValue;
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.safeAcquireTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        try (Statement ignore = transaction.acquireStatement();){
            transaction.dataWrite().graphSetProperty(propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) {
        int propertyKeyId;
        KernelTransaction transaction = this.safeAcquireTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        try (Statement ignore = transaction.acquireStatement();){
            Object object = transaction.dataWrite().graphRemoveProperty(propertyKeyId).asObjectCopy();
            return object;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            PropertyCursor properties = transaction.propertyCursor();
            TokenRead token = transaction.tokenRead();
            transaction.dataRead().graphProperties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... names) {
        Objects.requireNonNull(names, "Properties keys should be not null array.");
        if (names.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int itemsToReturn = names.length;
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = names[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        PropertyCursor propertyCursor = transaction.propertyCursor();
        transaction.dataRead().graphProperties(propertyCursor);
        int propertiesToFind = itemsToReturn;
        block1: while (propertiesToFind > 0 && propertyCursor.next()) {
            int currentKey = propertyCursor.propertyKey();
            for (int i = 0; i < itemsToReturn; ++i) {
                if (propertyIds[i] != currentKey) continue;
                properties.put(names[i], propertyCursor.propertyValue().asObjectCopy());
                --propertiesToFind;
                continue block1;
            }
        }
        return properties;
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            PropertyCursor propertyCursor = transaction.propertyCursor();
            TokenRead token = transaction.tokenRead();
            transaction.dataRead().graphProperties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    public boolean equals(Object o) {
        return o instanceof GraphPropertiesProxy && this.actions.getGraphDatabase() == ((GraphPropertiesProxy)o).actions.getGraphDatabase();
    }

    public int hashCode() {
        return this.actions.getGraphDatabase().hashCode();
    }

    private KernelTransaction safeAcquireTransaction() {
        KernelTransaction transaction = this.actions.kernelTransaction();
        if (transaction.isTerminated()) {
            Status terminationReason = transaction.getReasonIfTerminated().orElse((Status)Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
        return transaction;
    }
}

