/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import java.util.Collections;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.KernelExtensionUtil;

public class AllByPrioritySelectionStrategy<T extends Comparable<T>>
implements DependencyResolver.SelectionStrategy {
    private List<T> lowerPrioritizedCandidates = Collections.emptyList();

    public <R> R select(Class<R> type, Iterable<? extends R> candidates) throws IllegalArgumentException {
        List all = Iterables.asList(candidates);
        if (all.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve dependency of type: " + type.getName() + ". " + KernelExtensionUtil.servicesClassPathEntryInformation());
        }
        all.sort(Collections.reverseOrder());
        Object highest = all.remove(0);
        this.lowerPrioritizedCandidates = all;
        return (R)highest;
    }

    public Iterable<T> lowerPrioritizedCandidates() {
        return this.lowerPrioritizedCandidates;
    }
}

