/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.TimeZone;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;
import org.neo4j.unsafe.impl.batchimport.ImportMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class HumanUnderstandableExecutionMonitor
implements ExecutionMonitor {
    public static final Monitor NO_MONITOR = (stage, percent) -> {};
    public static final ExternalMonitor NO_EXTERNAL_MONITOR = () -> false;
    private static final String ESTIMATED_REQUIRED_MEMORY_USAGE = "Estimated required memory usage";
    private static final String ESTIMATED_DISK_SPACE_USAGE = "Estimated disk space usage";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES = "Estimated number of relationship properties";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIPS = "Estimated number of relationships";
    private static final String ESTIMATED_NUMBER_OF_NODE_PROPERTIES = "Estimated number of node properties";
    private static final String ESTIMATED_NUMBER_OF_NODES = "Estimated number of nodes";
    private static final int DOT_GROUP_SIZE = 10;
    private static final int DOT_GROUPS_PER_LINE = 5;
    private static final int PERCENTAGES_PER_LINE = 5;
    private final PrintStream out;
    private final Monitor monitor;
    private final ExternalMonitor externalMonitor;
    private DependencyResolver dependencyResolver;
    private long goal;
    private long stashedProgress;
    private long progress;
    private ImportStage currentStage;

    public HumanUnderstandableExecutionMonitor(PrintStream out, Monitor monitor, ExternalMonitor externalMonitor) {
        this.out = out;
        this.monitor = monitor;
        this.externalMonitor = externalMonitor;
    }

    @Override
    public void initialize(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        Input.Estimates estimates = (Input.Estimates)dependencyResolver.resolveDependency(Input.Estimates.class);
        BatchingNeoStores neoStores = (BatchingNeoStores)dependencyResolver.resolveDependency(BatchingNeoStores.class);
        IdMapper idMapper = (IdMapper)dependencyResolver.resolveDependency(IdMapper.class);
        NodeRelationshipCache nodeRelationshipCache = (NodeRelationshipCache)dependencyResolver.resolveDependency(NodeRelationshipCache.class);
        long biggestCacheMemory = ImportMemoryCalculator.estimatedCacheSize(neoStores, nodeRelationshipCache.memoryEstimation(estimates.numberOfNodes()), idMapper.memoryEstimation(estimates.numberOfNodes()));
        this.printStageHeader("Import starting", ESTIMATED_NUMBER_OF_NODES, Format.count(estimates.numberOfNodes()), ESTIMATED_NUMBER_OF_NODE_PROPERTIES, Format.count(estimates.numberOfNodeProperties()), ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count(estimates.numberOfRelationships()), ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES, Format.count(estimates.numberOfRelationshipProperties()), ESTIMATED_DISK_SPACE_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties() + estimates.sizeOfRelationshipProperties()), ESTIMATED_REQUIRED_MEMORY_USAGE, Format.bytes(biggestCacheMemory));
        this.out.println();
    }

    private static long baselineMemoryRequirement(BatchingNeoStores neoStores) {
        return GatheringMemoryStatsVisitor.totalMemoryUsageOf(neoStores);
    }

    private static long nodesDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfNodes() * (long)neoStores.getNodeStore().getRecordSize() + estimates.numberOfNodeLabels();
    }

    private static long relationshipsDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfRelationships() * (long)neoStores.getRelationshipStore().getRecordSize() * (long)(neoStores.usesDoubleRelationshipRecordUnits() ? 2 : 1);
    }

    @Override
    public void start(StageExecution execution) {
        if (execution.getStageName().equals("Nodes")) {
            this.initializeNodeImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Relationships")) {
            this.endPrevious();
            this.initializeRelationshipImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Node Degrees")) {
            this.endPrevious();
            this.initializeLinking((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (NodeRelationshipCache)this.dependencyResolver.resolveDependency(NodeRelationshipCache.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (execution.getStageName().equals("Count groups")) {
            this.endPrevious();
            this.initializeMisc((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.stashedProgress += this.progress;
            this.progress = 0L;
        }
    }

    private void endPrevious() {
        this.updateProgress(this.goal);
    }

    private void initializeNodeImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfNodes = estimates.numberOfNodes();
        this.printStageHeader("(1/4) Node import", ESTIMATED_NUMBER_OF_NODES, Format.count(numberOfNodes), ESTIMATED_DISK_SPACE_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties()), ESTIMATED_REQUIRED_MEMORY_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(idMapper.memoryEstimation(numberOfNodes))));
        long goal = idMapper.needsPreparation() ? numberOfNodes + HumanUnderstandableExecutionMonitor.weighted("Prepare node index", numberOfNodes * 4L) : numberOfNodes;
        this.initializeProgress(goal, ImportStage.nodeImport);
    }

    private void initializeRelationshipImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfRelationships = estimates.numberOfRelationships();
        this.printStageHeader("(2/4) Relationship import", ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count(numberOfRelationships), ESTIMATED_DISK_SPACE_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfRelationshipProperties()), ESTIMATED_REQUIRED_MEMORY_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + GatheringMemoryStatsVisitor.totalMemoryUsageOf(idMapper)));
        this.initializeProgress(numberOfRelationships, ImportStage.relationshipImport);
    }

    private void initializeLinking(BatchingNeoStores neoStores, NodeRelationshipCache nodeRelationshipCache, DataStatistics distribution) {
        this.printStageHeader("(3/4) Relationship linking", ESTIMATED_REQUIRED_MEMORY_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(nodeRelationshipCache.memoryEstimation(distribution.getNodeCount()))));
        long relationshipRecordIdCount = neoStores.getRelationshipStore().getHighId();
        long actualRelationshipCount = distribution.getRelationshipCount();
        this.initializeProgress(relationshipRecordIdCount + actualRelationshipCount * 2L + actualRelationshipCount * 2L, ImportStage.linking);
    }

    private void initializeMisc(BatchingNeoStores neoStores, DataStatistics distribution) {
        this.printStageHeader("(4/4) Post processing", ESTIMATED_REQUIRED_MEMORY_USAGE, Format.bytes(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores)));
        long actualNodeCount = distribution.getNodeCount();
        long relationshipRecordIdCount = neoStores.getRelationshipStore().getHighId();
        long groupCount = neoStores.getTemporaryRelationshipGroupStore().getHighId();
        this.initializeProgress(groupCount + groupCount + groupCount + actualNodeCount + relationshipRecordIdCount, ImportStage.postProcessing);
    }

    private void initializeProgress(long goal, ImportStage stage) {
        this.goal = goal;
        this.stashedProgress = 0L;
        this.progress = 0L;
        this.currentStage = stage;
    }

    private void updateProgress(long progress) {
        int maxDot = this.dotOf(this.goal);
        int currentProgressDot = this.dotOf(this.stashedProgress + this.progress);
        int currentLine = currentProgressDot / HumanUnderstandableExecutionMonitor.dotsPerLine();
        int currentDotOnLine = currentProgressDot % HumanUnderstandableExecutionMonitor.dotsPerLine();
        int progressDot = Integer.min(maxDot, this.dotOf(this.stashedProgress + progress));
        int line = progressDot / HumanUnderstandableExecutionMonitor.dotsPerLine();
        int dotOnLine = progressDot % HumanUnderstandableExecutionMonitor.dotsPerLine();
        while (currentLine < line || currentLine == line && currentDotOnLine < dotOnLine) {
            int target = currentLine < line ? HumanUnderstandableExecutionMonitor.dotsPerLine() : dotOnLine;
            this.printDots(currentDotOnLine, target);
            currentDotOnLine = target;
            if (currentLine >= line && currentDotOnLine != HumanUnderstandableExecutionMonitor.dotsPerLine()) continue;
            int percentage = HumanUnderstandableExecutionMonitor.percentage(currentLine);
            this.out.println(String.format(" %s%%", percentage));
            this.monitor.progress(this.currentStage, percentage);
            if (++currentLine == HumanUnderstandableExecutionMonitor.lines()) {
                this.out.println();
            }
            currentDotOnLine = 0;
        }
        this.progress = Long.max(this.progress, progress);
    }

    private static int percentage(int line) {
        return (line + 1) * 5;
    }

    private void printDots(int from, int target) {
        for (int current = from; current < target; ++current) {
            if (current > 0 && current % 10 == 0) {
                this.out.print(" ");
            }
            this.out.print(".");
        }
    }

    private int dotOf(long progress) {
        int dots = HumanUnderstandableExecutionMonitor.dotsPerLine() * HumanUnderstandableExecutionMonitor.lines();
        double dotSize = (double)this.goal / (double)dots;
        return (int)((double)progress / dotSize);
    }

    private static int lines() {
        return 20;
    }

    private static int dotsPerLine() {
        return 50;
    }

    private void printStageHeader(String name, Object ... data) {
        this.out.println(name + " " + Format.date(TimeZone.getDefault()));
        if (data.length > 0) {
            int i = 0;
            while (i < data.length) {
                this.out.println("  " + data[i++] + ": " + data[i++]);
            }
        }
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        this.endPrevious();
        this.out.println();
        this.out.println("IMPORT DONE in " + Format.duration(totalTimeMillis) + ". " + additionalInformation);
    }

    @Override
    public long nextCheckTime() {
        return System.currentTimeMillis() + 200L;
    }

    @Override
    public void check(StageExecution execution) {
        this.reprintProgressIfNecessary();
        if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.updateProgress(HumanUnderstandableExecutionMonitor.progressOf(execution));
        }
    }

    private void reprintProgressIfNecessary() {
        if (this.externalMonitor.somethingElseBrokeMyNiceOutput()) {
            long prevProgress = this.progress;
            long prevStashedProgress = this.stashedProgress;
            this.progress = 0L;
            this.stashedProgress = 0L;
            this.updateProgress(prevProgress + prevStashedProgress);
            this.progress = prevProgress;
            this.stashedProgress = prevStashedProgress;
        }
    }

    private static boolean includeStage(StageExecution execution) {
        String name = execution.getStageName();
        return !name.equals("RelationshipGroup") && !name.equals("Node --> Relationship") && !name.equals("Gather");
    }

    private static double weightOf(String stageName) {
        if (stageName.equals("Prepare node index")) {
            return 0.5;
        }
        return 1.0;
    }

    private static long weighted(String stageName, long progress) {
        return (long)((double)progress * HumanUnderstandableExecutionMonitor.weightOf(stageName));
    }

    private static long progressOf(StageExecution execution) {
        Stat progressStat = HumanUnderstandableExecutionMonitor.findProgressStat(execution.steps());
        if (progressStat != null) {
            return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), progressStat.asLong());
        }
        long doneBatches = ((Step)Iterables.last(execution.steps())).stats().stat(Keys.done_batches).asLong();
        int batchSize = execution.getConfig().batchSize();
        return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), doneBatches * (long)batchSize);
    }

    private static Stat findProgressStat(Iterable<Step<?>> steps) {
        for (Step<?> step : steps) {
            Stat stat = step.stats().stat(Keys.progress);
            if (stat == null) continue;
            return stat;
        }
        return null;
    }

    static enum ImportStage {
        nodeImport,
        relationshipImport,
        linking,
        postProcessing;

    }

    public static interface ExternalMonitor {
        public boolean somethingElseBrokeMyNiceOutput();
    }

    public static interface Monitor {
        public void progress(ImportStage var1, int var2);
    }
}

