/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class ConstraintRule
extends SchemaRule
implements ConstraintDescriptor.Supplier {
    private final Long ownedIndexRule;
    private final ConstraintDescriptor descriptor;

    public static ConstraintRule constraintRule(long id, ConstraintDescriptor descriptor) {
        return new ConstraintRule(id, descriptor, null);
    }

    public static ConstraintRule constraintRule(long id, IndexBackedConstraintDescriptor descriptor, long ownedIndexRule) {
        return new ConstraintRule(id, descriptor, ownedIndexRule);
    }

    public static ConstraintRule constraintRule(long id, ConstraintDescriptor descriptor, String name) {
        return new ConstraintRule(id, descriptor, null, name);
    }

    public static ConstraintRule constraintRule(long id, IndexBackedConstraintDescriptor descriptor, long ownedIndexRule, String name) {
        return new ConstraintRule(id, descriptor, ownedIndexRule, name);
    }

    ConstraintRule(long id, ConstraintDescriptor descriptor, Long ownedIndexRule) {
        this(id, descriptor, ownedIndexRule, null);
    }

    ConstraintRule(long id, ConstraintDescriptor descriptor, Long ownedIndexRule, String name) {
        super(id, name);
        this.descriptor = descriptor;
        this.ownedIndexRule = ownedIndexRule;
    }

    public String toString() {
        return "ConstraintRule[id=" + this.id + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.idTokenNameLookup) + ", ownedIndex=" + this.ownedIndexRule + "]";
    }

    public SchemaDescriptor schema() {
        return this.descriptor.schema();
    }

    public ConstraintDescriptor getConstraintDescriptor() {
        return this.descriptor;
    }

    public long getOwnedIndex() {
        if (this.ownedIndexRule == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndexRule;
    }

    @Override
    public byte[] serialize() {
        return SchemaRuleSerialization.serialize(this);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConstraintRule) {
            ConstraintRule that = (ConstraintRule)o;
            return this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }
}

