/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeZoneMapping {
    private static final List<String> TIME_ZONE_SHORT_TO_STRING = new ArrayList<String>(1024);
    private static final Map<String, Short> TIME_ZONE_STRING_TO_SHORT = new HashMap<String, Short>(1024);
    static final String LATEST_SUPPORTED_IANA_VERSION;

    private TimeZoneMapping() {
    }

    public static short map(String tzid) {
        if (!TIME_ZONE_STRING_TO_SHORT.containsKey(tzid)) {
            throw new IllegalArgumentException("tzid");
        }
        return TIME_ZONE_STRING_TO_SHORT.get(tzid);
    }

    public static String map(short offset) {
        return TIME_ZONE_SHORT_TO_STRING.get(offset);
    }

    static Collection<String> supportedTimeZones() {
        return TIME_ZONE_STRING_TO_SHORT.keySet();
    }

    static {
        String latestVersion = "";
        Pattern VERSION = Pattern.compile("# tzdata([0-9]{4}[a-z])");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(TimeZoneMapping.class.getResourceAsStream("/TZIDS")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//") || line.trim().isEmpty()) continue;
                if (line.startsWith("#")) {
                    Matcher matcher = VERSION.matcher(line);
                    if (!matcher.matches()) continue;
                    latestVersion = matcher.group(1);
                    continue;
                }
                int sep = line.indexOf(32);
                if (sep != -1) {
                    String oldName = line.substring(0, sep);
                    String newName = line.substring(sep + 1);
                    TIME_ZONE_SHORT_TO_STRING.add(newName);
                    TIME_ZONE_STRING_TO_SHORT.put(oldName, (short)(TIME_ZONE_SHORT_TO_STRING.size() - 1));
                    continue;
                }
                TIME_ZONE_SHORT_TO_STRING.add(line);
                TIME_ZONE_STRING_TO_SHORT.put(line, (short)(TIME_ZONE_SHORT_TO_STRING.size() - 1));
            }
            LATEST_SUPPORTED_IANA_VERSION = latestVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read time zone id file.");
        }
    }
}

