/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a DateTime instant.")
class DateTimeFunction
extends TemporalFunction<DateTimeValue> {
    DateTimeFunction() {
        super(Neo4jTypes.NTDateTime);
    }

    @Override
    protected DateTimeValue now(Clock clock, String timezone) {
        return timezone == null ? DateTimeValue.now((Clock)clock) : DateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateTimeValue positionalCreate(AnyValue[] input) {
        if (input.length != 8) {
            throw new IllegalArgumentException("expected 8 arguments");
        }
        return DateTimeValue.datetime((int)DateTimeFunction.anInt("year", input[0]), (int)DateTimeFunction.anInt("month", input[1]), (int)DateTimeFunction.anInt("day", input[2]), (int)DateTimeFunction.anInt("hour", input[3]), (int)DateTimeFunction.anInt("minute", input[4]), (int)DateTimeFunction.anInt("second", input[5]), (int)DateTimeFunction.anInt("nanos", input[6]), (String)DateTimeFunction.aString("timezone", input[7]));
    }

    @Override
    protected DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

