/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.newapi.HasChanges;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

abstract class RelationshipCursor
extends RelationshipRecord
implements RelationshipDataAccessor,
RelationshipVisitor<RuntimeException> {
    Read read;
    private HasChanges hasChanges = HasChanges.MAYBE;

    RelationshipCursor() {
        super(-1L);
    }

    protected void init(Read read) {
        this.read = read;
        this.hasChanges = HasChanges.MAYBE;
    }

    public long relationshipReference() {
        return this.getId();
    }

    public int label() {
        return this.getType();
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public void source(NodeCursor cursor) {
        this.read.singleNode(this.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.read.singleNode(this.targetNodeReference(), cursor);
    }

    public void properties(PropertyCursor cursor) {
        this.read.relationshipProperties(this.relationshipReference(), this.propertiesReference(), cursor);
    }

    public long sourceNodeReference() {
        return this.getFirstNode();
    }

    public long targetNodeReference() {
        return this.getSecondNode();
    }

    public long propertiesReference() {
        return this.getNextProp();
    }

    protected abstract void collectAddedTxStateSnapshot();

    protected boolean hasChanges() {
        switch (this.hasChanges) {
            case MAYBE: {
                boolean changes = this.read.hasTxStateWithChanges();
                if (changes) {
                    this.collectAddedTxStateSnapshot();
                    this.hasChanges = HasChanges.YES;
                } else {
                    this.hasChanges = HasChanges.NO;
                }
                return changes;
            }
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new IllegalStateException("Style guide, why are you making me do this");
    }

    protected void loadFromTxState(long reference) {
        this.read.txState().relationshipVisit(reference, this);
    }

    @Override
    public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
        this.setId(relationshipId);
        this.initialize(true, -1L, startNodeId, endNodeId, typeId, -1L, -1L, -1L, -1L, false, false);
    }
}

