/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;

class NodeValueClientFilter
implements IndexProgressor.NodeValueClient,
IndexProgressor {
    private static final Comparator<IndexQuery> ASCENDING_BY_KEY = Comparator.comparingInt(IndexQuery::propertyKeyId);
    private final IndexProgressor.NodeValueClient target;
    private final DefaultNodeCursor node;
    private final DefaultPropertyCursor property;
    private final IndexQuery[] filters;
    private final Read read;
    private int[] keys;
    private IndexProgressor progressor;

    NodeValueClientFilter(IndexProgressor.NodeValueClient target, DefaultNodeCursor node, DefaultPropertyCursor property, Read read, IndexQuery ... filters) {
        this.target = target;
        this.node = node;
        this.property = property;
        this.filters = filters;
        this.read = read;
        Arrays.sort(filters, ASCENDING_BY_KEY);
    }

    @Override
    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query) {
        this.progressor = progressor;
        this.keys = descriptor.schema().getPropertyIds();
        this.target.initialize(descriptor, this, query);
    }

    @Override
    public boolean acceptNode(long reference, Value[] values) {
        if (this.keys != null && values != null) {
            return this.filterByIndexValues(reference, values);
        }
        this.node.single(reference, this.read);
        if (!this.node.next()) {
            this.property.clear();
            return false;
        }
        this.node.properties(this.property);
        return this.filterByCursors(reference, values);
    }

    @Override
    public boolean needsValues() {
        return true;
    }

    @Override
    public boolean next() {
        return this.progressor.next();
    }

    @Override
    public void close() {
        this.node.close();
        this.property.close();
        this.progressor.close();
    }

    private boolean filterByIndexValues(long reference, Value[] values) {
        block0: for (IndexQuery filter : this.filters) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != filter.propertyKeyId()) continue;
                if (filter.acceptsValue(values[i])) continue block0;
                return false;
            }
            assert (false) : "Cannot satisfy filter " + filter + " - no corresponding key!";
            return false;
        }
        return this.target.acceptNode(reference, values);
    }

    private boolean filterByCursors(long reference, Value[] values) {
        int accepted = 0;
        block0: while (this.property.next()) {
            for (IndexQuery filter : this.filters) {
                if (filter.propertyKeyId() == this.property.propertyKey()) {
                    if (!filter.acceptsValueAt((PropertyCursor)this.property)) {
                        return false;
                    }
                    ++accepted;
                    continue;
                }
                if (this.property.propertyKey() < filter.propertyKeyId()) continue block0;
            }
        }
        return accepted >= this.filters.length && this.target.acceptNode(reference, values);
    }
}

