/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.storageengine.api.StoreReadLayer;

public class KernelToken
implements Token {
    private final StoreReadLayer store;

    public KernelToken(StoreReadLayer store) {
        this.store = store;
    }

    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        return this.store.labelGetOrCreateForName(this.checkValidTokenName(labelName));
    }

    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        return this.store.propertyKeyGetOrCreateForName(this.checkValidTokenName(propertyKeyName));
    }

    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        return this.store.relationshipTypeGetOrCreateForName(this.checkValidTokenName(relationshipTypeName));
    }

    public String nodeLabelName(int labelId) throws LabelNotFoundKernelException {
        return this.store.labelGetName(labelId);
    }

    public int nodeLabel(String name) {
        return this.store.labelGetForName(name);
    }

    public int relationshipType(String name) {
        return this.store.relationshipTypeGetForName(name);
    }

    public String relationshipTypeName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.store.relationshipTypeGetName(relationshipTypeId);
    }

    public int propertyKey(String name) {
        return this.store.propertyKeyGetForName(name);
    }

    public String propertyKeyName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.store.propertyKeyGetName(propertyKeyId);
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }
}

