/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.ExplicitIndexProgressor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class DefaultNodeExplicitIndexCursor
extends IndexCursor<ExplicitIndexProgressor>
implements NodeExplicitIndexCursor,
IndexProgressor.ExplicitClient {
    private Read read;
    private int expectedSize;
    private long node = -1L;
    private float score;

    DefaultNodeExplicitIndexCursor() {
    }

    @Override
    public void initialize(ExplicitIndexProgressor progressor, int expectedSize) {
        super.initialize(progressor);
        this.expectedSize = expectedSize;
    }

    @Override
    public boolean acceptEntity(long reference, float score) {
        this.node = reference;
        this.score = score;
        return true;
    }

    public boolean next() {
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public int expectedTotalNumberOfResults() {
        return this.expectedSize;
    }

    public float score() {
        return this.score;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.score = 0.0f;
        this.expectedSize = 0;
        this.read = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeExplicitIndexCursor[closed state]";
        }
        return "NodeExplicitIndexCursor[node=" + this.node + ", expectedSize=" + this.expectedSize + ", score=" + this.score + ", underlying record=" + super.toString() + " ]";
    }
}

