/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.SpatialKnownIndex;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialFusionIndexUpdater
implements IndexUpdater {
    private final Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap;
    private final Map<CoordinateReferenceSystem, IndexUpdater> currentUpdaters = new HashMap<CoordinateReferenceSystem, IndexUpdater>();
    private final long indexId;
    private final SpatialKnownIndex.Factory indexFactory;
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final boolean populating;

    static SpatialFusionIndexUpdater updaterForAccessor(Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap, long indexId, SpatialKnownIndex.Factory indexFactory, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new SpatialFusionIndexUpdater(indexMap, indexId, indexFactory, descriptor, samplingConfig, false);
    }

    static SpatialFusionIndexUpdater updaterForPopulator(Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap, long indexId, SpatialKnownIndex.Factory indexFactory, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new SpatialFusionIndexUpdater(indexMap, indexId, indexFactory, descriptor, samplingConfig, true);
    }

    private SpatialFusionIndexUpdater(Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap, long indexId, SpatialKnownIndex.Factory indexFactory, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, boolean populating) {
        this.indexMap = indexMap;
        this.indexId = indexId;
        this.indexFactory = indexFactory;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.populating = populating;
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                this.selectUpdater(update.values()).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = this.selectUpdater(update.beforeValues());
                IndexUpdater to = this.selectUpdater(update.values());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                this.selectUpdater(update.values()).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    private IndexUpdater selectUpdater(Value ... values) throws IOException {
        assert (values.length == 1);
        PointValue pointValue = (PointValue)values[0];
        CoordinateReferenceSystem crs = pointValue.getCoordinateReferenceSystem();
        IndexUpdater updater = this.currentUpdaters.get(crs);
        if (updater != null) {
            return updater;
        }
        SpatialKnownIndex index = this.indexFactory.selectAndCreate(this.indexMap, this.indexId, crs);
        IndexUpdater indexUpdater = index.updaterWithCreate(this.descriptor, this.samplingConfig, this.populating);
        return this.remember(crs, indexUpdater);
    }

    private IndexUpdater remember(CoordinateReferenceSystem crs, IndexUpdater indexUpdater) {
        this.currentUpdaters.put(crs, indexUpdater);
        return indexUpdater;
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        while (!this.currentUpdaters.isEmpty()) {
            FusionIndexUtils.forAll(updater -> ((IndexUpdater)updater).close(), this.currentUpdaters.values().toArray());
            this.currentUpdaters.clear();
        }
    }
}

