/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;

class FusionIndexAccessor
implements IndexAccessor {
    private final IndexAccessor nativeAccessor;
    private final IndexAccessor spatialAccessor;
    private final IndexAccessor luceneAccessor;
    private final FusionSchemaIndexProvider.Selector selector;
    private final long indexId;
    private final IndexDescriptor descriptor;
    private final FusionSchemaIndexProvider.DropAction dropAction;

    FusionIndexAccessor(IndexAccessor nativeAccessor, IndexAccessor spatialAccessor, IndexAccessor luceneAccessor, FusionSchemaIndexProvider.Selector selector, long indexId, IndexDescriptor descriptor, FusionSchemaIndexProvider.DropAction dropAction) {
        this.nativeAccessor = nativeAccessor;
        this.spatialAccessor = spatialAccessor;
        this.luceneAccessor = luceneAccessor;
        this.selector = selector;
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.dropAction = dropAction;
    }

    @Override
    public void drop() throws IOException {
        FusionIndexUtils.forAll(accessor -> ((IndexAccessor)accessor).drop(), this.nativeAccessor, this.spatialAccessor, this.luceneAccessor);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new FusionIndexUpdater(this.nativeAccessor.newUpdater(mode), this.spatialAccessor.newUpdater(mode), this.luceneAccessor.newUpdater(mode), this.selector);
    }

    @Override
    public void force() throws IOException {
        this.nativeAccessor.force();
        this.spatialAccessor.force();
        this.luceneAccessor.force();
    }

    @Override
    public void refresh() throws IOException {
        this.nativeAccessor.refresh();
        this.luceneAccessor.refresh();
    }

    @Override
    public void close() throws IOException {
        FusionIndexUtils.forAll(accessor -> ((IndexAccessor)accessor).close(), this.nativeAccessor, this.spatialAccessor, this.luceneAccessor);
    }

    @Override
    public IndexReader newReader() {
        return new FusionIndexReader(this.nativeAccessor.newReader(), this.spatialAccessor.newReader(), this.luceneAccessor.newReader(), this.selector, this.descriptor);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final BoundedIterable<Long> nativeAllEntries = this.nativeAccessor.newAllEntriesReader();
        final BoundedIterable<Long> spatialAllEntries = this.spatialAccessor.newAllEntriesReader();
        final BoundedIterable<Long> luceneAllEntries = this.luceneAccessor.newAllEntriesReader();
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long nativeMaxCount = nativeAllEntries.maxCount();
                long spatialMaxCount = spatialAllEntries.maxCount();
                long luceneMaxCount = luceneAllEntries.maxCount();
                return nativeMaxCount == -1L || spatialMaxCount == -1L || luceneMaxCount == -1L ? -1L : nativeMaxCount + spatialMaxCount + luceneMaxCount;
            }

            @Override
            public void close() throws Exception {
                FusionIndexUtils.forAll(entries -> ((BoundedIterable)entries).close(), nativeAllEntries, spatialAllEntries, luceneAllEntries);
            }

            @Override
            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable[])new Iterable[]{nativeAllEntries, spatialAllEntries, luceneAllEntries}).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return Iterators.concatResourceIterators(Arrays.asList(this.nativeAccessor.snapshotFiles(), this.spatialAccessor.snapshotFiles(), this.luceneAccessor.snapshotFiles()).iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.nativeAccessor.verifyDeferredConstraints(propertyAccessor);
        this.spatialAccessor.verifyDeferredConstraints(propertyAccessor);
        this.luceneAccessor.verifyDeferredConstraints(propertyAccessor);
    }
}

