/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.kernel.impl.index.schema.SpatialLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.SpatialLayoutUnique;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialKnownIndex {
    private UniqueIndexSampler uniqueSampler;
    private final File indexFile;
    private final PageCache pageCache;
    private final CoordinateReferenceSystem crs;
    private final long indexId;
    private final FileSystemAbstraction fs;
    private final SchemaIndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final SpaceFillingCurve curve;
    private State state;
    private boolean dropped;
    private byte[] failureBytes;
    private SpatialSchemaKey treeKey;
    private NativeSchemaValue treeValue;
    private SpatialLayout layout;
    private NativeSchemaIndexUpdater<SpatialSchemaKey, NativeSchemaValue> singleUpdater;
    private Writer<SpatialSchemaKey, NativeSchemaValue> singleTreeWriter;
    private NativeSchemaIndex<SpatialSchemaKey, NativeSchemaValue> schemaIndex;
    private WorkSync<NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>, NativeSchemaIndexPopulator.IndexUpdateWork<SpatialSchemaKey, NativeSchemaValue>> workSync;
    private DefaultNonUniqueIndexSampler generalSampler;

    public SpatialKnownIndex(IndexDirectoryStructure directoryStructure, CoordinateReferenceSystem crs, long indexId, PageCache pageCache, FileSystemAbstraction fs, SchemaIndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.crs = crs;
        this.indexId = indexId;
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        SchemaIndexProvider.Descriptor crsDescriptor = new SchemaIndexProvider.Descriptor(Integer.toString(crs.getTable().getTableId()), Integer.toString(crs.getCode()));
        IndexDirectoryStructure indexDir = IndexDirectoryStructure.directoriesBySubProvider(directoryStructure).forProvider(crsDescriptor);
        this.indexFile = new File(indexDir.directoryForIndex(indexId), "index-" + indexId);
        this.curve = new HilbertSpaceFillingCurve2D(SpatialKnownIndex.envelopeFromCRS(crs), 8);
        this.state = State.NONE;
    }

    public void init(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.state == State.NONE) {
            this.initialize(descriptor, samplingConfig);
        }
    }

    public void startPopulation(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        this.init(descriptor, samplingConfig);
        if (this.state == State.INIT) {
            this.create();
        }
        if (this.state != State.POPULATING) {
            throw new IllegalStateException("Failed to start populating index.");
        }
    }

    public void takeOnline(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        this.init(descriptor, samplingConfig);
        if (!this.indexExists()) {
            throw new IOException("Index file does not exist.");
        }
        if (this.state == State.INIT || this.state == State.POPULATED) {
            this.online();
        }
        if (this.state != State.ONLINE) {
            throw new IllegalStateException("Failed to bring index online.");
        }
    }

    public IndexUpdater updaterWithCreate(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, boolean populating) throws IOException {
        if (populating) {
            if (this.state == State.NONE) {
                this.initialize(descriptor, samplingConfig);
                this.create();
            }
            return this.newPopulatingUpdater();
        }
        if (this.state == State.NONE) {
            this.initialize(descriptor, samplingConfig);
            this.create();
            this.finishPopulation(true);
            this.online();
        }
        return this.newUpdater();
    }

    public void close() throws IOException {
        this.schemaIndex.closeTree();
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new NativeAllEntriesReader(this.schemaIndex.tree, this.layout);
    }

    public IndexReader newReader(IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        this.schemaIndex.assertOpen();
        return new SpatialSchemaIndexReader(this.schemaIndex.tree, this.layout, samplingConfig, descriptor);
    }

    public ResourceIterator<File> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFile));
    }

    public void force() throws IOException {
        this.schemaIndex.tree.checkpoint(IOLimiter.unlimited());
    }

    private IndexUpdater newUpdater() {
        this.schemaIndex.assertOpen();
        try {
            return this.singleUpdater.initialize((Writer<SpatialSchemaKey, NativeSchemaValue>)this.schemaIndex.tree.writer(), true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public synchronized void finishPopulation(boolean populationCompletedSuccessfully) throws IOException {
        assert (this.state == State.POPULATING);
        this.closeWriter();
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.schemaIndex.assertOpen();
                this.markTreeAsOnline();
                this.state = State.POPULATED;
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
                this.state = State.FAILED;
            }
        }
        finally {
            this.schemaIndex.closeTree();
        }
    }

    public void add(Collection<IndexEntryUpdate<?>> updates) throws IOException {
        this.applyWithWorkSync(updates);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        if (this.uniqueSampler != null) {
            this.uniqueSampler.increment(1L);
        } else if (this.generalSampler != null) {
            this.generalSampler.include(SamplingUtil.encodedStringValuesForSampling(update.values()));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public IndexSample sampleResult() {
        if (this.uniqueSampler != null) {
            return this.uniqueSampler.result();
        }
        if (this.generalSampler != null) {
            try {
                this.closeWriter();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                IndexSample indexSample = this.generalSampler.result();
                return indexSample;
            }
            finally {
                try {
                    this.instantiateWriter();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    private IndexUpdater newPopulatingUpdater() {
        return new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException {
                SpatialKnownIndex.this.applyWithWorkSync(this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    public synchronized void drop() throws IOException {
        try {
            this.closeWriter();
            this.schemaIndex.closeTree();
            this.schemaIndex.gbpTreeFileUtil.deleteFileIfPresent(this.indexFile);
        }
        finally {
            this.dropped = true;
            this.state = State.NONE;
        }
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
        this.state = State.FAILED;
    }

    public boolean indexExists() {
        return this.fs.fileExists(this.indexFile);
    }

    public String readPopulationFailure(IndexDescriptor descriptor) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)this.pageCache, (File)this.indexFile, (Layout)this.layout(descriptor), (Header.Reader)headerReader);
        return headerReader.failureMessage;
    }

    public InternalIndexState readState(IndexDescriptor descriptor) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)this.pageCache, (File)this.indexFile, (Layout)this.layout(descriptor), (Header.Reader)headerReader);
        switch (headerReader.state) {
            case 0: {
                return InternalIndexState.FAILED;
            }
            case 1: {
                return InternalIndexState.ONLINE;
            }
            case 2: {
                return InternalIndexState.POPULATING;
            }
        }
        throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
    }

    private synchronized void create() throws IOException {
        assert (this.state == State.INIT);
        this.schemaIndex.gbpTreeFileUtil.deleteFileIfPresent(this.indexFile);
        this.schemaIndex.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, new NativeSchemaIndexHeaderWriter(2));
        this.instantiateWriter();
        this.workSync = new WorkSync(new NativeSchemaIndexPopulator.IndexUpdateApply<SpatialSchemaKey, NativeSchemaValue>(this.treeKey, this.treeValue, this.singleTreeWriter, new ConflictDetectingValueMerger()));
        this.state = State.POPULATING;
    }

    private void initialize(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        assert (this.state == State.NONE);
        this.layout = this.layout(descriptor);
        this.treeKey = this.layout.newKey();
        this.treeValue = this.layout.newValue();
        this.schemaIndex = new NativeSchemaIndex(this.pageCache, this.fs, this.indexFile, this.layout, this.monitor, descriptor, this.indexId);
        if (this.isUnique(descriptor)) {
            this.uniqueSampler = new UniqueIndexSampler();
        } else {
            this.generalSampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
        }
        this.state = State.INIT;
    }

    private void online() throws IOException {
        assert (this.state == State.POPULATED || this.state == State.INIT);
        this.singleUpdater = new NativeSchemaIndexUpdater<SpatialSchemaKey, NativeSchemaValue>(this.treeKey, this.treeValue);
        this.schemaIndex.instantiateTree(this.recoveryCleanupWorkCollector, GBPTree.NO_HEADER_WRITER);
        this.state = State.ONLINE;
    }

    private void instantiateWriter() throws IOException {
        assert (this.singleTreeWriter == null);
        this.singleTreeWriter = this.schemaIndex.tree.writer();
    }

    private void applyWithWorkSync(Collection<? extends IndexEntryUpdate<?>> updates) throws IOException {
        try {
            this.workSync.apply(new NativeSchemaIndexPopulator.IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private void closeWriter() throws IOException {
        this.singleTreeWriter = this.schemaIndex.closeIfPresent(this.singleTreeWriter);
    }

    private void markTreeAsOnline() throws IOException {
        this.schemaIndex.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.schemaIndex.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.schemaIndex.tree == null) {
            this.schemaIndex.instantiateTree(RecoveryCleanupWorkCollector.IGNORE, GBPTree.NO_HEADER_WRITER);
        }
    }

    private SpatialLayout layout(IndexDescriptor descriptor) {
        SpatialLayout layout = this.isUnique(descriptor) ? new SpatialLayoutUnique(this.crs, this.curve) : new SpatialLayoutNonUnique(this.crs, this.curve);
        return layout;
    }

    private boolean isUnique(IndexDescriptor descriptor) {
        switch (descriptor.type()) {
            case GENERAL: {
                return false;
            }
            case UNIQUE: {
                return true;
            }
        }
        throw new UnsupportedOperationException("Unexpected index type " + (Object)((Object)descriptor.type()));
    }

    static Envelope envelopeFromCRS(CoordinateReferenceSystem crs) {
        Envelope curveEnvelope = crs.equals((Object)CoordinateReferenceSystem.WGS84) ? new Envelope(-180.0, 180.0, -90.0, 90.0) : new Envelope(-1000000.0, 1000000.0, -1000000.0, 1000000.0);
        return curveEnvelope;
    }

    public static interface Factory {
        public SpatialKnownIndex selectAndCreate(Map<CoordinateReferenceSystem, SpatialKnownIndex> var1, long var2, CoordinateReferenceSystem var4);
    }

    private static enum State {
        NONE,
        INIT,
        POPULATING,
        POPULATED,
        ONLINE,
        FAILED;

    }
}

