/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;

public class NativeAllEntriesReader<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
implements BoundedIterable<Long> {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private RawCursor<Hit<KEY, VALUE>, IOException> seeker;

    NativeAllEntriesReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout) {
        this.tree = tree;
        this.layout = layout;
    }

    @Override
    public Iterator<Long> iterator() {
        NativeSchemaKey from = (NativeSchemaKey)this.layout.newKey();
        from.initAsLowest();
        NativeSchemaKey to = (NativeSchemaKey)this.layout.newKey();
        to.initAsHighest();
        try {
            this.closeSeeker();
            this.seeker = this.tree.seek((Object)from, (Object)to);
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    try {
                        return NativeAllEntriesReader.this.seeker.next() ? Long.valueOf(((NativeSchemaKey)((Hit)NativeAllEntriesReader.this.seeker.get()).key()).getEntityId()) : null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void closeSeeker() throws IOException {
        if (this.seeker != null) {
            this.seeker.close();
            this.seeker = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.closeSeeker();
    }

    @Override
    public long maxCount() {
        return -1L;
    }
}

