/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphPropertiesProxy;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.AutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProviderImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.coreapi.ReadOnlyIndexFacade;
import org.neo4j.kernel.impl.coreapi.ReadOnlyRelationshipIndexFacade;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class GraphDatabaseFacade
implements GraphDatabaseAPI,
EmbeddedProxySPI {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private Schema schema;
    private Supplier<IndexManager> indexManager;
    private ThreadToStatementContextBridge statementContext;
    private SPI spi;
    private TransactionalContextFactory contextFactory;
    private Config config;
    private RelationshipTypeTokenHolder relationshipTypeTokenHolder;

    public void init(SPI spi, Guard guard, ThreadToStatementContextBridge txBridge, Config config, RelationshipTypeTokenHolder relationshipTypeTokenHolder) {
        this.spi = spi;
        this.config = config;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.schema = new SchemaImpl(txBridge);
        this.statementContext = txBridge;
        this.indexManager = Suppliers.lazySingleton(() -> {
            IndexProviderImpl idxProvider = new IndexProviderImpl(this, txBridge);
            AutoIndexerFacade<Node> nodeAutoIndexer = new AutoIndexerFacade<Node>(() -> new ReadOnlyIndexFacade<Node>((ReadableIndex<Node>)idxProvider.getOrCreateNodeIndex("node_auto_index", null)), spi.autoIndexing().nodes());
            RelationshipAutoIndexerFacade relAutoIndexer = new RelationshipAutoIndexerFacade(() -> new ReadOnlyRelationshipIndexFacade(idxProvider.getOrCreateRelationshipIndex("relationship_auto_index", null)), spi.autoIndexing().relationships());
            return new IndexManagerImpl(txBridge, idxProvider, nodeAutoIndexer, relAutoIndexer);
        });
        this.contextFactory = Neo4jTransactionalContextFactory.create(spi, guard, txBridge, locker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode() {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            NodeProxy nodeProxy = this.newNodeProxy(transaction.dataWrite().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long createNodeId() {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            Long l = transaction.dataWrite().nodeCreate();
            return l;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode(Label ... labels) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            Write write = transaction.dataWrite();
            long nodeId = write.nodeCreate();
            for (Label label : labels) {
                int labelId = transaction.tokenWrite().labelGetOrCreateForName(label.name());
                try {
                    write.nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", (Throwable)((Object)e));
                }
            }
            NodeProxy nodeProxy = this.newNodeProxy(nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getNodeById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)((Object)new EntityNotFoundException(EntityType.NODE, id)));
        }
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        try (Statement ignore = ktx.acquireStatement();){
            if (!ktx.dataRead().nodeExists(id)) {
                throw new NotFoundException(String.format("Node %d not found", id), (Throwable)((Object)new EntityNotFoundException(EntityType.NODE, id)));
            }
            NodeProxy nodeProxy = this.newNodeProxy(id);
            return nodeProxy;
        }
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)((Object)new EntityNotFoundException(EntityType.RELATIONSHIP, id)));
        }
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        try (Statement ignore = this.statementContext.get();){
            if (!ktx.dataRead().relationshipExists(id)) {
                throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)((Object)new EntityNotFoundException(EntityType.RELATIONSHIP, id)));
            }
            RelationshipProxy relationshipProxy = this.newRelationshipProxy(id);
            return relationshipProxy;
        }
    }

    public IndexManager index() {
        return this.indexManager.get();
    }

    public Schema schema() {
        this.assertTransactionOpen();
        return this.schema;
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.spi.databaseIsAvailable(timeoutMillis);
    }

    public void shutdown() {
        this.spi.shutdown();
    }

    public Transaction beginTx() {
        return this.beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
    }

    public Transaction beginTx(long timeout, TimeUnit unit) {
        return this.beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED, timeout, unit);
    }

    @Override
    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext) {
        return this.beginTransactionInternal(type, loginContext, this.config.get(GraphDatabaseSettings.transaction_timeout).toMillis());
    }

    @Override
    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext, long timeout, TimeUnit unit) {
        return this.beginTransactionInternal(type, loginContext, unit.toMillis(timeout));
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, long timeout, TimeUnit unit) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap(), timeout, unit);
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        InternalTransaction transaction = this.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        return this.execute(transaction, query, ValueUtils.asMapValue(parameters));
    }

    public Result execute(String query, Map<String, Object> parameters, long timeout, TimeUnit unit) throws QueryExecutionException {
        InternalTransaction transaction = this.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, timeout, unit);
        return this.execute(transaction, query, ValueUtils.asMapValue(parameters));
    }

    public Result execute(InternalTransaction transaction, String query, MapValue parameters) throws QueryExecutionException {
        TransactionalContext context = this.contextFactory.newContext(ClientConnectionInfo.EMBEDDED_CONNECTION, transaction, query, parameters);
        return this.spi.executeQuery(query, parameters, context);
    }

    public ResourceIterable<Node> getAllNodes() {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        return () -> {
            final Statement statement = ktx.acquireStatement();
            final NodeCursor cursor = ktx.cursors().allocateNodeCursor();
            ktx.dataRead().allNodesScan(cursor);
            return new PrefetchingResourceIterator<Node>(){

                protected Node fetchNextOrNull() {
                    if (cursor.next()) {
                        return GraphDatabaseFacade.this.newNodeProxy(cursor.nodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                    statement.close();
                }
            };
        };
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        return () -> {
            final Statement statement = ktx.acquireStatement();
            final RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor();
            ktx.dataRead().allRelationshipsScan(cursor);
            return new PrefetchingResourceIterator<Relationship>(){

                protected Relationship fetchNextOrNull() {
                    if (cursor.next()) {
                        return GraphDatabaseFacade.this.newRelationshipProxy(cursor.relationshipReference(), cursor.sourceNodeReference(), cursor.label(), cursor.targetNodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                    statement.close();
                }
            };
        };
    }

    public ResourceIterable<Label> getAllLabelsInUse() {
        return this.allInUse(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    private <T> ResourceIterable<T> allInUse(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> tokens.inUse(this.statementContext.get());
    }

    public ResourceIterable<Label> getAllLabels() {
        return this.all(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypes() {
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    private <T> ResourceIterable<T> all(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> tokens.all(this.statementContext.get());
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.spi.registerKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.registerTransactionEventHandler(handler);
        return handler;
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        this.spi.unregisterKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.unregisterTransactionEventHandler(handler);
        return handler;
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        return this.nodesByLabelAndProperty(myLabel, key, Values.of((Object)value));
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple nodes with label: '%s', property name: '%s' and property value: '%s' while only one was expected.", myLabel, key, value));
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    private InternalTransaction beginTransactionInternal(Transaction.Type type, LoginContext loginContext, long timeoutMillis) {
        if (this.statementContext.hasTransaction()) {
            return new PlaceboTransaction(this.statementContext.getKernelTransactionBoundToThisThread(true), this.statementContext);
        }
        return new TopLevelTransaction(this.spi.beginTransaction(type, loginContext, timeoutMillis), this.statementContext);
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(Label myLabel, String key, Value value) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        Statement statement = transaction.acquireStatement();
        Read read = transaction.dataRead();
        TokenRead tokenRead = transaction.tokenRead();
        int propertyId = tokenRead.propertyKey(key);
        int labelId = tokenRead.nodeLabel(myLabel.name());
        if (propertyId == -1 || labelId == -1) {
            statement.close();
            return Iterators.emptyResourceIterator();
        }
        CapableIndexReference index = transaction.schemaRead().index(labelId, new int[]{propertyId});
        if (index != CapableIndexReference.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor();
                IndexQuery.ExactPredicate query = IndexQuery.exact((int)propertyId, (Object)value);
                read.nodeIndexSeek((IndexReference)index, cursor, IndexOrder.NONE, new IndexQuery[]{query});
                return new NodeCursorResourceIterator<NodeValueIndexCursor>(cursor, statement, this::newNodeProxy);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(propertyId, value, statement, labelId);
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int propertyId, Value value, Statement statement, int labelId) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        NodeLabelIndexCursor nodeLabelCursor = transaction.cursors().allocateNodeLabelIndexCursor();
        NodeCursor nodeCursor = transaction.cursors().allocateNodeCursor();
        PropertyCursor propertyCursor = transaction.cursors().allocatePropertyCursor();
        transaction.dataRead().nodeLabelScan(labelId, nodeLabelCursor);
        return new NodeLabelPropertyIterator(transaction.dataRead(), nodeLabelCursor, nodeCursor, propertyCursor, statement, this::newNodeProxy, propertyId, value);
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        Statement statement = ktx.acquireStatement();
        int labelId = ktx.tokenRead().nodeLabel(myLabel.name());
        if (labelId == -1) {
            statement.close();
            return ResourceIterator.empty();
        }
        NodeLabelIndexCursor cursor = ktx.cursors().allocateNodeLabelIndexCursor();
        ktx.dataRead().nodeLabelScan(labelId, cursor);
        return new NodeCursorResourceIterator<NodeLabelIndexCursor>(cursor, statement, this::newNodeProxy);
    }

    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.statementContext);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.statementContext);
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.spi.resolver();
    }

    @Override
    public StoreId storeId() {
        return this.spi.storeId();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.spi.validateURLAccess(url);
    }

    @Override
    public File getStoreDir() {
        return this.spi.storeDir();
    }

    public String toString() {
        return this.spi.name() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Statement statement() {
        return this.statementContext.get();
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.statementContext.getKernelTransactionBoundToThisThread(true);
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this;
    }

    @Override
    public void assertInUnterminatedTransaction() {
        this.statementContext.assertInUnterminatedTransaction();
    }

    @Override
    public void failTransaction() {
        this.statementContext.getKernelTransactionBoundToThisThread(true).failure();
    }

    @Override
    public RelationshipProxy newRelationshipProxy(long id) {
        return new RelationshipProxy(this, id);
    }

    @Override
    public RelationshipProxy newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipProxy(this, id, startNodeId, typeId, endNodeId);
    }

    @Override
    public NodeProxy newNodeProxy(long nodeId) {
        return new NodeProxy(this, nodeId);
    }

    @Override
    public RelationshipType getRelationshipTypeById(int type) {
        try {
            return (RelationshipType)this.relationshipTypeTokenHolder.getTokenById(type);
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type);
        }
    }

    @Override
    public int getRelationshipTypeIdByName(String typeName) {
        return this.relationshipTypeTokenHolder.getIdByName(typeName);
    }

    @Override
    public GraphPropertiesProxy newGraphPropertiesProxy() {
        return new GraphPropertiesProxy(this);
    }

    private void assertTransactionOpen() {
        this.assertTransactionOpen(this.statementContext.getKernelTransactionBoundToThisThread(true));
    }

    private void assertTransactionOpen(KernelTransaction transaction) {
        if (transaction.isTerminated()) {
            Status terminationReason = transaction.getReasonIfTerminated().orElse((Status)Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    private static interface NodeFactory {
        public NodeProxy make(long var1);
    }

    private static abstract class PrefetchingNodeResourceIterator
    implements ResourceIterator<Node> {
        private final Statement statement;
        private final NodeFactory nodeFactory;
        private long next;
        private boolean closed;
        private static final long NOT_INITIALIZED = -2L;
        protected static final long NO_ID = -1L;

        PrefetchingNodeResourceIterator(Statement statement, NodeFactory nodeFactory) {
            this.statement = statement;
            this.nodeFactory = nodeFactory;
            this.next = -2L;
        }

        public boolean hasNext() {
            if (this.next == -2L) {
                this.next = this.fetchNext();
            }
            return this.next != -1L;
        }

        public Node next() {
            if (!this.hasNext()) {
                this.close();
                throw new NoSuchElementException();
            }
            NodeProxy nodeProxy = this.nodeFactory.make(this.next);
            this.next = this.fetchNext();
            return nodeProxy;
        }

        public void close() {
            if (!this.closed) {
                this.next = -1L;
                this.closeResources(this.statement);
                this.closed = true;
            }
        }

        abstract long fetchNext();

        abstract void closeResources(Statement var1);
    }

    private static final class NodeCursorResourceIterator<CURSOR extends NodeIndexCursor>
    extends PrefetchingNodeResourceIterator {
        private final CURSOR cursor;

        NodeCursorResourceIterator(CURSOR cursor, Statement statement, NodeFactory nodeFactory) {
            super(statement, nodeFactory);
            this.cursor = cursor;
        }

        @Override
        long fetchNext() {
            if (this.cursor.next()) {
                return this.cursor.nodeReference();
            }
            this.close();
            return -1L;
        }

        @Override
        void closeResources(Statement statement) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{statement, this.cursor});
        }
    }

    private static class NodeLabelPropertyIterator
    extends PrefetchingNodeResourceIterator {
        private final Read read;
        private final NodeLabelIndexCursor nodeLabelCursor;
        private final NodeCursor nodeCursor;
        private final PropertyCursor propertyCursor;
        private final int propertyKeyId;
        private final Value value;

        NodeLabelPropertyIterator(Read read, NodeLabelIndexCursor nodeLabelCursor, NodeCursor nodeCursor, PropertyCursor propertyCursor, Statement statement, NodeFactory nodeFactory, int propertyKeyId, Value value) {
            super(statement, nodeFactory);
            this.read = read;
            this.nodeLabelCursor = nodeLabelCursor;
            this.nodeCursor = nodeCursor;
            this.propertyCursor = propertyCursor;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        @Override
        protected long fetchNext() {
            boolean hasNext;
            while ((hasNext = this.nodeLabelCursor.next()) && !this.hasPropertyWithValue()) {
            }
            if (hasNext) {
                return this.nodeLabelCursor.nodeReference();
            }
            this.close();
            return -1L;
        }

        @Override
        void closeResources(Statement statement) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{statement, this.nodeLabelCursor, this.nodeCursor, this.propertyCursor});
        }

        private boolean hasPropertyWithValue() {
            this.read.singleNode(this.nodeLabelCursor.nodeReference(), this.nodeCursor);
            if (this.nodeCursor.next()) {
                this.nodeCursor.properties(this.propertyCursor);
                while (this.propertyCursor.next()) {
                    if (this.propertyCursor.propertyKey() != this.propertyKeyId || !this.propertyCursor.propertyValue().equals(this.value)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SPI {
        public boolean databaseIsAvailable(long var1);

        public DependencyResolver resolver();

        public StoreId storeId();

        public File storeDir();

        public String name();

        public void shutdown();

        public KernelTransaction beginTransaction(Transaction.Type var1, LoginContext var2, long var3);

        public Result executeQuery(String var1, Map<String, Object> var2, TransactionalContext var3);

        public Result executeQuery(String var1, MapValue var2, TransactionalContext var3);

        public AutoIndexing autoIndexing();

        public void registerKernelEventHandler(KernelEventHandler var1);

        public void unregisterKernelEventHandler(KernelEventHandler var1);

        public <T> void registerTransactionEventHandler(TransactionEventHandler<T> var1);

        public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> var1);

        public URL validateURLAccess(URL var1) throws URLAccessValidationError;

        public GraphDatabaseQueryService queryService();
    }
}

