/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.time.Duration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class MonitorGc
implements Lifecycle {
    private final Config config;
    private final Log log;
    private volatile MeasureDoNothing monitorGc;

    public MonitorGc(Config config, Log log) {
        this.config = config;
        this.log = log;
    }

    public void init() {
    }

    public void start() {
        this.monitorGc = new MeasureDoNothing("neo4j.PauseMonitor", MeasureDoNothing.loggingMonitor(this.log), this.config.get(Configuration.gc_monitor_wait_time).toMillis(), this.config.get(Configuration.gc_monitor_threshold).toMillis());
        this.monitorGc.start();
    }

    public void stop() {
        this.monitorGc.stopMeasuring();
        this.monitorGc = null;
    }

    public void shutdown() {
    }

    public static class Configuration {
        public static final Setting<Duration> gc_monitor_wait_time = Settings.setting("unsupported.dbms.gc_monitor_wait_time", Settings.DURATION, "100ms");
        public static final Setting<Duration> gc_monitor_threshold = Settings.setting("unsupported.dbms.gc_monitor_threshold", Settings.DURATION, "200ms");
    }
}

