/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.logging.Log;

public class MeasureDoNothing
extends Thread {
    private volatile boolean measure = true;
    private final Monitor monitor;
    private final long TIME_TO_WAIT;
    private final long NOTIFICATION_THRESHOLD;

    public static Monitor loggingMonitor(final Log log) {
        return new Monitor(){

            @Override
            public void started() {
                log.debug("GC Monitor started. ");
            }

            @Override
            public void stopped() {
                log.debug("GC Monitor stopped. ");
            }

            @Override
            public void blocked(long millis) {
                log.warn(String.format("GC Monitor: Application threads blocked for %dms.", millis));
            }
        };
    }

    public MeasureDoNothing(String threadName, Monitor monitor, long timeToWait, long pauseNotificationThreshold) {
        super(threadName);
        this.monitor = monitor;
        this.TIME_TO_WAIT = timeToWait;
        this.NOTIFICATION_THRESHOLD = pauseNotificationThreshold + timeToWait;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.monitor.started();
        while (this.measure) {
            long time;
            long start = System.nanoTime();
            try {
                Thread.sleep(this.TIME_TO_WAIT);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            if ((time = (System.nanoTime() - start) / 1000000L) <= this.NOTIFICATION_THRESHOLD) continue;
            long blockTime = time - this.TIME_TO_WAIT;
            this.monitor.blocked(blockTime);
        }
        this.monitor.stopped();
    }

    public void stopMeasuring() {
        this.measure = false;
        this.interrupt();
    }

    public static class CollectingMonitor
    implements Monitor {
        private long gcBlockTime;

        @Override
        public void blocked(long millis) {
            this.gcBlockTime += millis;
        }

        public long getGcBlockTime() {
            return this.gcBlockTime;
        }
    }

    public static interface Monitor {
        default public void started() {
        }

        public void blocked(long var1);

        default public void stopped() {
        }
    }
}

