/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.logging.LogProvider;

class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStoreView storeView;
    private final SchemaIndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStoreView storeView, SchemaIndexProviderMap providerMap, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.samplingConfig = samplingConfig;
        this.storeView = storeView;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    IndexProxy createPopulatingIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean flipToTentative, IndexingService.Monitor monitor, IndexPopulationJob populationJob) {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexPopulator populator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
        IndexMeta indexMeta = this.indexMetaFromProvider(providerDescriptor, descriptor);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(indexMeta, populator, indexUserDescription, new IndexCountsRemover(this.storeView, ruleId), this.logProvider);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(indexMeta, populationJob);
        populationJob.addPopulator(populator, ruleId, indexMeta, indexUserDescription, flipper, failureDelegateFactory);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(descriptor);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(ruleId, indexMeta, this.onlineAccessorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig), this.storeView, true);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper, false);
    }

    IndexProxy createRecoveringIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        IndexMeta indexMeta = this.indexMetaFromProvider(providerDescriptor, descriptor);
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(indexMeta);
        return new ContractCheckingIndexProxy(proxy, true);
    }

    IndexProxy createOnlineIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        try {
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
            IndexMeta indexMeta = this.indexMetaFromProvider(providerDescriptor, descriptor);
            IndexProxy proxy = new OnlineIndexProxy(ruleId, indexMeta, onlineAccessor, this.storeView, false);
            proxy = new ContractCheckingIndexProxy(proxy, true);
            return proxy;
        }
        catch (IOException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + ruleId + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(descriptor, providerDescriptor);
        }
    }

    IndexProxy createFailedIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexPopulationFailure populationFailure) {
        IndexPopulator indexPopulator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, this.samplingConfig);
        IndexMeta indexMeta = this.indexMetaFromProvider(providerDescriptor, descriptor);
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexProxy proxy = new FailedIndexProxy(indexMeta, indexUserDescription, indexPopulator, populationFailure, new IndexCountsRemover(this.storeView, ruleId), this.logProvider);
        proxy = new ContractCheckingIndexProxy(proxy, true);
        return proxy;
    }

    private String indexUserDescription(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        return String.format("%s [provider: %s]", descriptor.schema().userDescription(this.tokenNameLookup), providerDescriptor.toString());
    }

    private IndexPopulator populatorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getPopulator(ruleId, descriptor, samplingConfig);
    }

    private IndexAccessor onlineAccessorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getOnlineAccessor(ruleId, descriptor, samplingConfig);
    }

    private IndexMeta indexMetaFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, IndexDescriptor indexDescriptor) {
        IndexCapability indexCapability = this.providerMap.apply(providerDescriptor).getCapability(indexDescriptor);
        return new IndexMeta(indexDescriptor, providerDescriptor, indexCapability);
    }
}

