/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveIntStack;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.ExplicitIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.ExplicitIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.IndexTxStateUpdater;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class StateHandlingStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityOperations,
SchemaReadOperations,
SchemaWriteOperations,
CountsOperations,
ExplicitIndexReadOperations,
ExplicitIndexWriteOperations {
    private final StoreReadLayer storeLayer;
    private final AutoIndexing autoIndexing;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ExplicitIndexStore explicitIndexStore;
    private final IndexTxStateUpdater indexTxStateUpdater;

    public StateHandlingStatementOperations(StoreReadLayer storeLayer, AutoIndexing propertyTrackers, ConstraintIndexCreator constraintIndexCreator, ExplicitIndexStore explicitIndexStore) {
        this.storeLayer = storeLayer;
        this.autoIndexing = propertyTrackers;
        this.constraintIndexCreator = constraintIndexCreator;
        this.explicitIndexStore = explicitIndexStore;
        this.indexTxStateUpdater = new IndexTxStateUpdater(storeLayer, this);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        Cursor<NodeItem> node = this.nodeCursor(statement, nodeId);
        if (!node.next()) {
            node.close();
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    private Cursor<NodeItem> nodeCursor(KernelStatement statement, long nodeId) {
        Cursor<NodeItem> cursor = statement.getStoreStatement().acquireSingleNodeCursor(nodeId);
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentSingleNodeCursor(cursor, nodeId);
        }
        return cursor;
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relationshipId) throws EntityNotFoundException {
        Cursor<RelationshipItem> relationship = this.relationshipCursor(statement, relationshipId);
        if (!relationship.next()) {
            relationship.close();
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    private Cursor<RelationshipItem> relationshipCursor(KernelStatement statement, long relationshipId) {
        Cursor<RelationshipItem> cursor = statement.getStoreStatement().acquireSingleRelationshipCursor(relationshipId);
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentSingleRelationshipCursor(cursor, relationshipId);
        }
        return cursor;
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        Cursor<RelationshipItem> cursor = statement.getStoreStatement().relationshipsGetAllCursor();
        if (statement.hasTxStateWithChanges()) {
            return statement.txState().augmentRelationshipsGetAllCursor(cursor);
        }
        return cursor;
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? Cursors.empty() : this.storeLayer.nodeGetRelationships(statement.getStoreStatement(), node, direction);
        if (!statement.hasTxStateWithChanges()) {
            return cursor;
        }
        NodeState nodeState = statement.txState().getNodeState(node.id());
        return statement.txState().augmentNodeRelationshipCursor((Cursor<RelationshipItem>)cursor, nodeState, direction);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(KernelStatement statement, NodeItem node, Direction direction, int[] relTypes) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? Cursors.empty() : this.storeLayer.nodeGetRelationships(statement.getStoreStatement(), node, direction, Predicates.any((int[])relTypes));
        if (!statement.hasTxStateWithChanges()) {
            return cursor;
        }
        NodeState nodeState = statement.txState().getNodeState(node.id());
        return statement.txState().augmentNodeRelationshipCursor((Cursor<RelationshipItem>)cursor, nodeState, direction, relTypes);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(KernelStatement statement, NodeItem node) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? Cursors.empty() : this.storeLayer.nodeGetProperties(statement.getStoreStatement(), node, statement);
        return statement.hasTxStateWithChanges() ? statement.txState().augmentPropertyCursor((Cursor<PropertyItem>)cursor, statement.txState().getNodeState(node.id())) : cursor;
    }

    @Override
    public PrimitiveIntCollection nodeGetPropertyKeys(KernelStatement statement, NodeItem node) {
        PrimitiveIntStack keys = new PrimitiveIntStack();
        try (Cursor<PropertyItem> properties = this.nodeGetProperties(statement, node);){
            while (properties.next()) {
                keys.push(((PropertyItem)properties.get()).propertyKeyId());
            }
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value nodeGetProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        try (Cursor<PropertyItem> cursor = this.nodeGetPropertyCursor(statement, node, propertyKeyId);){
            if (!cursor.next()) return Values.NO_VALUE;
            Value value = ((PropertyItem)cursor.get()).value();
            return value;
        }
        catch (NotFoundException e) {
            return Values.NO_VALUE;
        }
    }

    @Override
    public boolean nodeHasProperty(KernelStatement statement, NodeItem node, int propertyKeyId) {
        try (Cursor<PropertyItem> cursor = this.nodeGetPropertyCursor(statement, node, propertyKeyId);){
            boolean bl = cursor.next();
            return bl;
        }
    }

    private Cursor<PropertyItem> nodeGetPropertyCursor(KernelStatement statement, NodeItem node, int propertyKeyId) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? Cursors.empty() : this.storeLayer.nodeGetProperty(statement.getStoreStatement(), node, propertyKeyId, statement);
        return statement.hasTxStateWithChanges() ? statement.txState().augmentSinglePropertyCursor((Cursor<PropertyItem>)cursor, statement.txState().getNodeState(node.id()), propertyKeyId) : cursor;
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(KernelStatement statement, RelationshipItem relationship) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().relationshipIsAddedInThisTx(relationship.id()) ? Cursors.empty() : this.storeLayer.relationshipGetProperties(statement.getStoreStatement(), relationship, statement);
        return statement.hasTxStateWithChanges() ? statement.txState().augmentPropertyCursor((Cursor<PropertyItem>)cursor, statement.txState().getRelationshipState(relationship.id())) : cursor;
    }

    @Override
    public PrimitiveIntCollection relationshipGetPropertyKeys(KernelStatement statement, RelationshipItem relationship) {
        PrimitiveIntStack keys = new PrimitiveIntStack();
        try (Cursor<PropertyItem> properties = this.relationshipGetProperties(statement, relationship);){
            while (properties.next()) {
                keys.push(((PropertyItem)properties.get()).propertyKeyId());
            }
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Value relationshipGetProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        try (Cursor<PropertyItem> cursor = this.relationshipGetPropertyCursor(statement, relationship, propertyKeyId);){
            if (!cursor.next()) return Values.NO_VALUE;
            Value value = ((PropertyItem)cursor.get()).value();
            return value;
        }
        catch (NotFoundException e) {
            return Values.NO_VALUE;
        }
    }

    @Override
    public boolean relationshipHasProperty(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        try (Cursor<PropertyItem> cursor = this.relationshipGetPropertyCursor(statement, relationship, propertyKeyId);){
            boolean bl = cursor.next();
            return bl;
        }
    }

    private Cursor<PropertyItem> relationshipGetPropertyCursor(KernelStatement statement, RelationshipItem relationship, int propertyKeyId) {
        Object cursor = statement.hasTxStateWithChanges() && statement.txState().relationshipIsAddedInThisTx(relationship.id()) ? Cursors.empty() : this.storeLayer.relationshipGetProperty(statement.getStoreStatement(), relationship, propertyKeyId, statement);
        return statement.hasTxStateWithChanges() ? statement.txState().augmentSinglePropertyCursor((Cursor<PropertyItem>)cursor, statement.txState().getRelationshipState(relationship.id()), propertyKeyId) : cursor;
    }

    @Override
    public long nodeCreate(KernelStatement state) {
        long nodeId = state.getStoreStatement().reserveNode();
        state.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws AutoIndexingKernelException, EntityNotFoundException, InvalidTransactionTypeKernelException {
        this.autoIndexing.nodes().entityRemoved(state.dataWriteOperations(), nodeId);
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            state.txState().nodeDoDelete(((NodeItem)cursor.get()).id());
        }
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.nodeDelete(state, nodeId);
        return 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            this.autoIndexing.relationships().entityRemoved(state.dataWriteOperations(), relationshipId);
            TransactionState txState = state.txState();
            if (txState.relationshipIsAddedInThisTx(relationship.id())) {
                txState.relationshipDoDeleteAddedInThisTx(relationship.id());
            } else {
                txState.relationshipDoDelete(relationship.id(), relationship.type(), relationship.startNode(), relationship.endNode());
            }
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        PrimitiveLongIterator iterator = this.storeLayer.nodesGetAll();
        return state.hasTxStateWithChanges() ? state.txState().augmentNodesGetAll(iterator) : iterator;
    }

    @Override
    public RelationshipIterator relationshipsGetAll(KernelStatement state) {
        RelationshipIterator iterator = this.storeLayer.relationshipsGetAll();
        return state.hasTxStateWithChanges() ? state.txState().augmentRelationshipsGetAll(iterator) : iterator;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            if (node.hasLabel(labelId)) {
                boolean bl = false;
                return bl;
            }
            state.txState().nodeDoAddLabel(labelId, node.id());
            this.indexTxStateUpdater.onLabelChange(state, labelId, node, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            if (!node.hasLabel(labelId)) {
                boolean bl = false;
                return bl;
            }
            state.txState().nodeDoRemoveLabel(labelId, node.id());
            this.indexTxStateUpdater.onLabelChange(state, labelId, node, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetForLabel(KernelStatement state, int labelId) {
        PrimitiveLongResourceIterator committed = this.storeLayer.nodesGetForLabel(state.getStoreStatement(), labelId);
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongResourceIterator wLabelChanges = (PrimitiveLongResourceIterator)state.txState().nodesWithLabelChanged(labelId).augment(committed);
            return (PrimitiveLongResourceIterator)state.txState().addedAndRemovedNodes().augmentWithRemovals(wLabelChanges);
        }
        return committed;
    }

    @Override
    public long nodesGetCount(KernelStatement state) {
        long base = this.storeLayer.nodesGetCount();
        return state.hasTxStateWithChanges() ? base + (long)state.txState().addedAndRemovedNodes().delta() : base;
    }

    @Override
    public long relationshipsGetCount(KernelStatement state) {
        long base = this.storeLayer.relationshipsGetCount();
        return state.hasTxStateWithChanges() ? base + (long)state.txState().addedAndRemovedRelationships().delta() : base;
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, LabelSchemaDescriptor descriptor) {
        IndexDescriptor indexDescriptor = IndexDescriptorFactory.forSchema(descriptor);
        state.txState().indexRuleDoAdd(indexDescriptor);
        return indexDescriptor;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) {
        state.txState().indexDoDrop(descriptor);
    }

    private void indexBackedConstraintCreate(KernelStatement state, IndexBackedConstraintDescriptor constraint) throws CreateConstraintFailureException {
        LabelSchemaDescriptor descriptor = constraint.schema();
        try {
            if (state.hasTxStateWithChanges() && state.txState().indexDoUnRemove(constraint.ownedIndexDescriptor())) {
                if (!state.txState().constraintDoUnRemove(constraint)) {
                    state.txState().constraintDoAdd(constraint, state.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<ConstraintDescriptor> it = this.storeLayer.constraintsGetForSchema((SchemaDescriptor)descriptor);
                while (it.hasNext()) {
                    if (!it.next().equals(constraint)) continue;
                    return;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, descriptor);
                if (!this.constraintExists(state, constraint)) {
                    state.txState().constraintDoAdd(constraint, indexId);
                }
            }
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, (Throwable)e);
        }
    }

    @Override
    public NodeKeyConstraintDescriptor nodeKeyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor);
        this.indexBackedConstraintCreate(state, constraint);
        return constraint;
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
        this.indexBackedConstraintCreate(state, constraint);
        return constraint;
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) {
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        state.txState().constraintDoAdd(constraint);
        return constraint;
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationTypeSchemaDescriptor descriptor) {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        state.txState().constraintDoAdd(constraint);
        return constraint;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(KernelStatement state, SchemaDescriptor descriptor) {
        Iterator<ConstraintDescriptor> constraints = this.storeLayer.constraintsGetForSchema(descriptor);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForSchema(descriptor).apply(constraints);
        }
        return constraints;
    }

    @Override
    public boolean constraintExists(KernelStatement state, ConstraintDescriptor descriptor) {
        boolean inStore = this.storeLayer.constraintExists(descriptor);
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<ConstraintDescriptor> diffSet = state.txState().constraintsChangesForSchema(descriptor.schema());
            return diffSet.isAdded(descriptor) || inStore && !diffSet.isRemoved(descriptor);
        }
        return inStore;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(KernelStatement state, int labelId) {
        Iterator<ConstraintDescriptor> constraints = this.storeLayer.constraintsGetForLabel(labelId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(KernelStatement state, int typeId) {
        Iterator<ConstraintDescriptor> constraints = this.storeLayer.constraintsGetForRelationshipType(typeId);
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll(KernelStatement state) {
        Iterator<ConstraintDescriptor> constraints = this.storeLayer.constraintsGetAll();
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, ConstraintDescriptor constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexGetForSchema(KernelStatement state, LabelSchemaDescriptor descriptor) {
        IndexDescriptor indexDescriptor = this.storeLayer.indexGetForSchema(descriptor);
        Iterator rules = Iterators.iterator((Object)indexDescriptor);
        if (state.hasTxStateWithChanges()) {
            rules = Iterators.filter((Predicate)SchemaDescriptor.equalTo((SchemaDescriptor)descriptor), state.txState().indexDiffSetsByLabel(descriptor.getLabelId()).apply(rules));
        }
        return (IndexDescriptor)Iterators.singleOrNull((Iterator)rules);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges() && this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.schema().getLabelId()))) {
            return InternalIndexState.POPULATING;
        }
        return this.storeLayer.indexGetState(descriptor);
    }

    @Override
    public SchemaIndexProvider.Descriptor indexGetProviderDescriptor(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges() && this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.schema().getLabelId()))) {
            return SchemaIndexProvider.UNDECIDED;
        }
        return this.storeLayer.indexGetProviderDescriptor(descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges() && this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.schema().getLabelId()))) {
            return PopulationProgress.NONE;
        }
        return this.storeLayer.indexGetPopulationProgress(descriptor.schema());
    }

    private boolean checkIndexState(IndexDescriptor index, ReadableDiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(index)) {
            return true;
        }
        if (diffSet.isRemoved(index)) {
            throw new IndexNotFoundKernelException(String.format("Index on %s has been dropped in this transaction.", index.userDescription(SchemaUtil.idTokenNameLookup)));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.storeLayer.indexesGetForLabel(labelId));
        }
        return this.storeLayer.indexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.storeLayer.indexesGetAll());
        }
        return this.storeLayer.indexesGetAll();
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, IndexQuery.ExactPredicate ... query) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        IndexReader reader = state.getStoreStatement().getFreshIndexReader(index);
        PrimitiveLongResourceIterator committed = PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)reader.query((IndexQuery[])query), (Resource)reader);
        PrimitiveLongResourceIterator exactMatches = reader.hasFullValuePrecision((IndexQuery[])query) ? committed : LookupFilter.exactIndexMatches(this, state, committed, (IndexQuery[])query);
        PrimitiveLongResourceIterator changesFiltered = this.filterIndexStateChangesForSeek(state, exactMatches, index, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])query));
        return PrimitiveLongCollections.single((PrimitiveLongIterator)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)changesFiltered, (Resource)committed), (long)-1L);
    }

    @Override
    public PrimitiveLongResourceIterator indexQuery(KernelStatement state, IndexDescriptor index, IndexQuery ... predicates) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        StorageStatement storeStatement = state.getStoreStatement();
        IndexReader reader = storeStatement.getIndexReader(index);
        PrimitiveLongResourceIterator committed = reader.query(predicates);
        PrimitiveLongResourceIterator exactMatches = reader.hasFullValuePrecision(predicates) ? committed : LookupFilter.exactIndexMatches(this, state, committed, predicates);
        IndexQuery firstPredicate = predicates[0];
        switch (firstPredicate.type()) {
            case exact: {
                IndexQuery.ExactPredicate[] exactPreds = StateHandlingStatementOperations.assertOnlyExactPredicates(predicates);
                return this.filterIndexStateChangesForSeek(state, exactMatches, index, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])exactPreds));
            }
            case stringSuffix: 
            case stringContains: 
            case exists: {
                return this.filterIndexStateChangesForScan(state, exactMatches, index);
            }
            case rangeNumeric: {
                this.assertSinglePredicate(predicates);
                IndexQuery.NumberRangePredicate numPred = (IndexQuery.NumberRangePredicate)firstPredicate;
                return this.filterIndexStateChangesForRangeSeekByNumber(state, index, numPred.from(), numPred.fromInclusive(), numPred.to(), numPred.toInclusive(), exactMatches);
            }
            case rangeGeometric: {
                this.assertSinglePredicate(predicates);
                IndexQuery.GeometryRangePredicate geomPred = (IndexQuery.GeometryRangePredicate)firstPredicate;
                return this.filterIndexStateChangesForRangeSeekByGeometry(state, index, geomPred.from(), geomPred.fromInclusive(), geomPred.to(), geomPred.toInclusive(), exactMatches);
            }
            case rangeString: {
                this.assertSinglePredicate(predicates);
                IndexQuery.StringRangePredicate strPred = (IndexQuery.StringRangePredicate)firstPredicate;
                return this.filterIndexStateChangesForRangeSeekByString(state, index, strPred.from(), strPred.fromInclusive(), strPred.to(), strPred.toInclusive(), committed);
            }
            case stringPrefix: {
                this.assertSinglePredicate(predicates);
                IndexQuery.StringPrefixPredicate strPred = (IndexQuery.StringPrefixPredicate)firstPredicate;
                return this.filterIndexStateChangesForRangeSeekByPrefix(state, index, strPred.prefix(), committed);
            }
        }
        throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(predicates));
    }

    public static IndexQuery.ExactPredicate[] assertOnlyExactPredicates(IndexQuery[] predicates) {
        IndexQuery.ExactPredicate[] exactPredicates;
        if (predicates.getClass() == IndexQuery.ExactPredicate[].class) {
            exactPredicates = (IndexQuery.ExactPredicate[])predicates;
        } else {
            exactPredicates = new IndexQuery.ExactPredicate[predicates.length];
            for (int i = 0; i < predicates.length; ++i) {
                if (!(predicates[i] instanceof IndexQuery.ExactPredicate)) {
                    throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(predicates));
                }
                exactPredicates[i] = (IndexQuery.ExactPredicate)predicates[i];
            }
        }
        return exactPredicates;
    }

    private void assertSinglePredicate(IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(predicates));
        }
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, IndexDescriptor index, long nodeId, Value value) throws IndexNotFoundKernelException {
        IndexReader reader = statement.getStoreStatement().getIndexReader(index);
        return reader.countIndexedNodes(nodeId, value);
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForScan(KernelStatement state, PrimitiveLongResourceIterator nodeIds, IndexDescriptor index) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongReadableDiffSets labelPropertyChanges = state.txState().indexUpdatesForScan(index);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChanges.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForSeek(KernelStatement state, PrimitiveLongResourceIterator nodeIds, IndexDescriptor index, ValueTuple propertyValues) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongReadableDiffSets labelPropertyChanges = state.txState().indexUpdatesForSeek(index, propertyValues);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChanges.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForRangeSeekByNumber(KernelStatement state, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper, PrimitiveLongResourceIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongReadableDiffSets labelPropertyChangesForNumber = txState.indexUpdatesForRangeSeekByNumber(index, lower, includeLower, upper, includeUpper);
            ReadableDiffSets<Long> nodes = txState.addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChangesForNumber.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForRangeSeekByGeometry(KernelStatement state, IndexDescriptor index, PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper, PrimitiveLongResourceIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongReadableDiffSets labelPropertyChangesForGeometry = txState.indexUpdatesForRangeSeekByGeometry(index, lower, includeLower, upper, includeUpper);
            ReadableDiffSets<Long> nodes = txState.addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChangesForGeometry.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForRangeSeekByString(KernelStatement state, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper, PrimitiveLongResourceIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongReadableDiffSets labelPropertyChangesForString = txState.indexUpdatesForRangeSeekByString(index, lower, includeLower, upper, includeUpper);
            ReadableDiffSets<Long> nodes = txState.addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChangesForString.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    private PrimitiveLongResourceIterator filterIndexStateChangesForRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix, PrimitiveLongResourceIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongReadableDiffSets labelPropertyChangesForPrefix = txState.indexUpdatesForRangeSeekByPrefix(index, prefix);
            ReadableDiffSets<Long> nodes = txState.addedAndRemovedNodes();
            return (PrimitiveLongResourceIterator)nodes.augmentWithRemovals(labelPropertyChangesForPrefix.augment((PrimitiveLongIterator)nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Value nodeSetProperty(KernelStatement state, long nodeId, int propertyKeyId, Value value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            Value value2;
            NodeItem node = (NodeItem)cursor.get();
            Value existingValue = Values.NO_VALUE;
            try (Cursor<PropertyItem> properties = this.nodeGetPropertyCursor(state, node, propertyKeyId);){
                if (!properties.next()) {
                    this.autoIndexing.nodes().propertyAdded(ops, nodeId, propertyKeyId, value);
                } else {
                    existingValue = ((PropertyItem)properties.get()).value();
                    this.autoIndexing.nodes().propertyChanged(ops, nodeId, propertyKeyId, existingValue, value);
                }
            }
            if (existingValue == Values.NO_VALUE) {
                state.txState().nodeDoAddProperty(node.id(), propertyKeyId, value);
                this.indexTxStateUpdater.onPropertyAdd(state, node, propertyKeyId, value);
                value2 = Values.NO_VALUE;
                return value2;
            }
            if (this.propertyHasChanged(value, existingValue)) {
                state.txState().nodeDoChangeProperty(node.id(), propertyKeyId, existingValue, value);
                this.indexTxStateUpdater.onPropertyChange(state, node, propertyKeyId, existingValue, value);
            }
            value2 = existingValue;
            return value2;
        }
    }

    @Override
    public Value relationshipSetProperty(KernelStatement state, long relationshipId, int propertyKeyId, Value value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            Value existingValue = Values.NO_VALUE;
            try (Cursor<PropertyItem> properties = this.relationshipGetPropertyCursor(state, relationship, propertyKeyId);){
                if (!properties.next()) {
                    this.autoIndexing.relationships().propertyAdded(ops, relationshipId, propertyKeyId, value);
                } else {
                    existingValue = ((PropertyItem)properties.get()).value();
                    this.autoIndexing.relationships().propertyChanged(ops, relationshipId, propertyKeyId, existingValue, value);
                }
            }
            if (this.propertyHasChanged(value, existingValue)) {
                state.txState().relationshipDoReplaceProperty(relationship.id(), propertyKeyId, existingValue, value);
            }
            Value value2 = existingValue;
            return value2;
        }
    }

    @Override
    public Value graphSetProperty(KernelStatement state, int propertyKeyId, Value value) {
        Value existingValue = this.graphGetProperty(state, propertyKeyId);
        if (!value.equals(existingValue)) {
            state.txState().graphDoReplaceProperty(propertyKeyId, existingValue, value);
        }
        return existingValue;
    }

    @Override
    public Value nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            Value existingValue = Values.NO_VALUE;
            try (Cursor<PropertyItem> properties = this.nodeGetPropertyCursor(state, node, propertyKeyId);){
                if (properties.next()) {
                    existingValue = ((PropertyItem)properties.get()).value();
                    this.autoIndexing.nodes().propertyRemoved(ops, nodeId, propertyKeyId);
                    state.txState().nodeDoRemoveProperty(node.id(), propertyKeyId, existingValue);
                    this.indexTxStateUpdater.onPropertyRemove(state, node, propertyKeyId, existingValue);
                }
            }
            Value value = existingValue;
            return value;
        }
    }

    @Override
    public Value relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        DataWriteOperations ops = state.dataWriteOperations();
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorById(state, relationshipId);){
            RelationshipItem relationship = (RelationshipItem)cursor.get();
            Value existingValue = Values.NO_VALUE;
            try (Cursor<PropertyItem> properties = this.relationshipGetPropertyCursor(state, relationship, propertyKeyId);){
                if (properties.next()) {
                    existingValue = ((PropertyItem)properties.get()).value();
                    this.autoIndexing.relationships().propertyRemoved(ops, relationshipId, propertyKeyId);
                    state.txState().relationshipDoRemoveProperty(relationship.id(), propertyKeyId, existingValue);
                }
            }
            Value value = existingValue;
            return value;
        }
    }

    @Override
    public Value graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Value existingValue = this.graphGetProperty(state, propertyKeyId);
        if (existingValue != Values.NO_VALUE) {
            state.txState().graphDoRemoveProperty(propertyKeyId, existingValue);
        }
        return existingValue;
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetPropertyKeys();
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        return this.graphGetProperty(state, propertyKeyId) != Values.NO_VALUE;
    }

    @Override
    public Value graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<StorageProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            StorageProperty property = properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property.value();
        }
        return Values.NO_VALUE;
    }

    private Iterator<StorageProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().augmentGraphProperties(this.storeLayer.graphGetAllProperties());
        }
        return this.storeLayer.graphGetAllProperties();
    }

    @Override
    public long countsForNode(KernelStatement statement, int labelId) {
        long count = this.countsForNodeWithoutTxState(statement, labelId);
        if (statement.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                statement.txState().accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeLayer, statement.getStoreStatement(), statement.txState(), counts));
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    @Override
    public long countsForNodeWithoutTxState(KernelStatement statement, int labelId) {
        return this.storeLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(KernelStatement statement, int startLabelId, int typeId, int endLabelId) {
        long count = this.countsForRelationshipWithoutTxState(statement, startLabelId, typeId, endLabelId);
        if (statement.hasTxStateWithChanges()) {
            CountsRecordState counts = new CountsRecordState();
            try {
                statement.txState().accept(new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storeLayer, statement.getStoreStatement(), statement.txState(), counts));
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
                }
            }
            catch (ConstraintValidationException | CreateConstraintFailureException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    @Override
    public long countsForRelationshipWithoutTxState(KernelStatement statement, int startLabelId, int typeId, int endLabelId) {
        return this.storeLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public long indexSize(KernelStatement statement, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexSize(descriptor.schema());
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement statement, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexUniqueValuesPercentage(descriptor.schema());
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(KernelStatement statement, IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.storeLayer.indexUpdatesAndSize(index.schema(), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(KernelStatement statement, IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.storeLayer.indexSample(index.schema(), target);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) {
        return this.storeLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetCommittedId(index);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexGetFailure(descriptor.schema());
    }

    @Override
    public int labelGetForName(Statement state, String labelName) {
        return this.storeLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        return this.storeLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.storeLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.storeLayer.labelsGetAllTokens();
    }

    @Override
    public Iterator<Token> relationshipTypesGetAllTokens(Statement state) {
        return this.storeLayer.relationshipTypeGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.storeLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String labelName) throws TooManyLabelsException {
        return this.storeLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) {
        state.txState().labelDoCreateForName(labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) {
        state.txState().propertyKeyDoCreateForName(propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) {
        state.txState().relationshipTypeDoCreateForName(relationshipTypeName, id);
    }

    @Override
    public int labelCount(KernelStatement statement) {
        return this.storeLayer.labelCount();
    }

    @Override
    public int propertyKeyCount(KernelStatement statement) {
        return this.storeLayer.propertyKeyCount();
    }

    @Override
    public int relationshipTypeCount(KernelStatement statement) {
        return this.storeLayer.relationshipTypeCount();
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        if (statement.hasTxStateWithChanges() && statement.txState().relationshipVisit(relId, visitor)) {
            return;
        }
        this.storeLayer.relationshipVisit(relId, visitor);
    }

    @Override
    public boolean nodeExplicitIndexExists(KernelStatement statement, String indexName, Map<String, String> customConfiguration) {
        return statement.explicitIndexTxState().checkIndexExistence(IndexEntityType.Node, indexName, customConfiguration);
    }

    @Override
    public boolean relationshipExplicitIndexExists(KernelStatement statement, String indexName, Map<String, String> customConfiguration) {
        return statement.explicitIndexTxState().checkIndexExistence(IndexEntityType.Relationship, indexName, customConfiguration);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexGet(KernelStatement statement, String indexName, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        return statement.explicitIndexTxState().nodeChanges(indexName).get(key, value);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
        return statement.explicitIndexTxState().nodeChanges(indexName).query(key, queryOrQueryObject);
    }

    @Override
    public ExplicitIndexHits nodeExplicitIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject) throws ExplicitIndexNotFoundKernelException {
        return statement.explicitIndexTxState().nodeChanges(indexName).query(queryOrQueryObject);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexGet(KernelStatement statement, String indexName, String key, Object value, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        ExplicitIndex index = statement.explicitIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.get(key, value, startNode, endNode);
        }
        return index.get(key, value);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        ExplicitIndex index = statement.explicitIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(key, queryOrQueryObject, startNode, endNode);
        }
        return index.query(key, queryOrQueryObject);
    }

    @Override
    public ExplicitIndexHits relationshipExplicitIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject, long startNode, long endNode) throws ExplicitIndexNotFoundKernelException {
        ExplicitIndex index = statement.explicitIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(queryOrQueryObject, startNode, endNode);
        }
        return index.query(queryOrQueryObject);
    }

    @Override
    public void nodeExplicitIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    @Override
    public void nodeExplicitIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    @Override
    public void relationshipExplicitIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    @Override
    public void relationshipExplicitIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    @Override
    public void nodeAddToExplicitIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    @Override
    public void nodeRemoveFromExplicitIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    @Override
    public void nodeRemoveFromExplicitIndex(KernelStatement statement, String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    @Override
    public void nodeRemoveFromExplicitIndex(KernelStatement statement, String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    @Override
    public void relationshipAddToExplicitIndex(KernelStatement statement, String indexName, long relationship, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.relationshipVisit(statement, relationship, (relId, type, startNode, endNode) -> statement.explicitIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, startNode, endNode));
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(KernelStatement statement, String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        try {
            this.relationshipVisit(statement, relationship, (relId, type, startNode, endNode) -> statement.explicitIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, value, startNode, endNode));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(KernelStatement statement, String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException {
        try {
            this.relationshipVisit(statement, relationship, (relId, type, startNode, endNode) -> statement.explicitIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, startNode, endNode));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromExplicitIndex(KernelStatement statement, String indexName, long relationship) throws ExplicitIndexNotFoundKernelException {
        try {
            this.relationshipVisit(statement, relationship, (relId, type, startNode, endNode) -> statement.explicitIndexTxState().relationshipChanges(indexName).removeRelationship(relId, startNode, endNode));
        }
        catch (EntityNotFoundException e) {
            statement.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
        }
    }

    @Override
    public void nodeExplicitIndexDrop(KernelStatement statement, String indexName) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().nodeChanges(indexName).drop();
        statement.explicitIndexTxState().deleteIndex(IndexEntityType.Node, indexName);
    }

    @Override
    public void relationshipExplicitIndexDrop(KernelStatement statement, String indexName) throws ExplicitIndexNotFoundKernelException {
        statement.explicitIndexTxState().relationshipChanges(indexName).drop();
        statement.explicitIndexTxState().deleteIndex(IndexEntityType.Relationship, indexName);
    }

    @Override
    public String nodeExplicitIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.setNodeIndexConfiguration(indexName, key, value);
    }

    @Override
    public String relationshipExplicitIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.setRelationshipIndexConfiguration(indexName, key, value);
    }

    @Override
    public String nodeExplicitIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.removeNodeIndexConfiguration(indexName, key);
    }

    @Override
    public String relationshipExplicitIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.removeRelationshipIndexConfiguration(indexName, key);
    }

    @Override
    public Map<String, String> nodeExplicitIndexGetConfiguration(KernelStatement statement, String indexName) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.getNodeIndexConfiguration(indexName);
    }

    @Override
    public Map<String, String> relationshipExplicitIndexGetConfiguration(KernelStatement statement, String indexName) throws ExplicitIndexNotFoundKernelException {
        return this.explicitIndexStore.getRelationshipIndexConfiguration(indexName);
    }

    @Override
    public String[] nodeExplicitIndexesGetAll(KernelStatement statement) {
        return this.explicitIndexStore.getAllNodeIndexNames();
    }

    @Override
    public String[] relationshipExplicitIndexesGetAll(KernelStatement statement) {
        return this.explicitIndexStore.getAllRelationshipIndexNames();
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        if (statement.hasTxStateWithChanges()) {
            TransactionState txState = statement.txState();
            if (txState.nodeIsDeletedInThisTx(id)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(id)) {
                return true;
            }
        }
        return this.storeLayer.nodeExists(id);
    }

    @Override
    public PrimitiveIntSet relationshipTypes(KernelStatement statement, NodeItem node) {
        if (statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id())) {
            return statement.txState().getNodeState(node.id()).relationshipTypes();
        }
        PrimitiveIntSet types = statement.hasTxStateWithChanges() ? statement.txState().getNodeState(node.id()).relationshipTypes() : Primitive.intSet();
        types.addAll(PrimitiveIntCollections.filter((PrimitiveIntIterator)this.storeLayer.relationshipTypes(statement.getStoreStatement(), node).iterator(), current -> !types.contains(current) && this.degree(statement, node, Direction.BOTH, current) > 0));
        return types;
    }

    @Override
    public int degree(KernelStatement statement, NodeItem node, Direction direction) {
        int degree = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? 0 : this.computeDegree(statement, node, direction, null);
        return statement.hasTxStateWithChanges() ? statement.txState().getNodeState(node.id()).augmentDegree(direction, degree) : degree;
    }

    @Override
    public int degree(KernelStatement statement, NodeItem node, Direction direction, int relType) {
        int degree = statement.hasTxStateWithChanges() && statement.txState().nodeIsAddedInThisTx(node.id()) ? 0 : this.computeDegree(statement, node, direction, relType);
        return statement.hasTxStateWithChanges() ? statement.txState().getNodeState(node.id()).augmentDegree(direction, degree, relType) : degree;
    }

    private int computeDegree(KernelStatement statement, NodeItem node, Direction direction, Integer relType) {
        StorageStatement storeStatement = statement.getStoreStatement();
        if (node.isDense()) {
            return this.storeLayer.degreeRelationshipsInGroup(storeStatement, node.id(), node.nextGroupId(), direction, relType);
        }
        return Cursors.count(relType == null ? this.storeLayer.nodeGetRelationships(storeStatement, node, direction) : this.storeLayer.nodeGetRelationships(storeStatement, node, direction, t -> t == relType));
    }

    private boolean propertyHasChanged(Value lhs, Value rhs) {
        return lhs.getClass() != rhs.getClass() || !lhs.equals(rhs);
    }
}

