/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;

public final class KeyReadTokenNameLookup
implements TokenNameLookup {
    private final KeyReadOperations read;

    public KeyReadTokenNameLookup(KeyReadOperations read) {
        this.read = read;
    }

    public String labelGetName(int labelId) {
        try {
            return this.read.labelGetName(null, labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    public String relationshipTypeGetName(int relTypeId) {
        try {
            return this.read.relationshipTypeGetName(null, relTypeId);
        }
        catch (RelationshipTypeIdNotFoundKernelException e) {
            return "[" + relTypeId + "]";
        }
    }

    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.read.propertyKeyGetName(null, propertyKeyId);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            return "[" + propertyKeyId + "]";
        }
    }
}

