/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.CachingInputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;

class CachingInputIterator
implements InputIterator {
    private final InputIterator actual;
    private final InputCacher cacher;

    CachingInputIterator(InputIterator actual, InputCacher cacher) {
        this.actual = actual;
        this.cacher = cacher;
    }

    @Override
    public void close() throws IOException {
        this.actual.close();
        this.cacher.close();
    }

    @Override
    public boolean next(InputChunk chunk) throws IOException {
        return this.actual.next(((CachingInputChunk)chunk).actual());
    }

    @Override
    public InputChunk newChunk() {
        return new CachingInputChunk(this.actual.newChunk(), this.cacher);
    }
}

