/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public interface StoreReadLayer {
    public StorageStatement newStatement();

    public Iterator<IndexDescriptor> indexesGetForLabel(int var1);

    public Iterator<IndexDescriptor> indexesGetAll();

    public Iterator<IndexDescriptor> indexesGetRelatedToProperty(int var1);

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor var1);

    public long indexGetCommittedId(IndexDescriptor var1) throws SchemaRuleNotFoundException;

    public PrimitiveIntIterator graphGetPropertyKeys();

    public Object graphGetProperty(int var1);

    public Iterator<StorageProperty> graphGetAllProperties();

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor var1);

    public boolean constraintExists(ConstraintDescriptor var1);

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetAll();

    public PrimitiveLongResourceIterator nodesGetForLabel(StorageStatement var1, int var2);

    public IndexDescriptor indexGetForSchema(LabelSchemaDescriptor var1);

    public InternalIndexState indexGetState(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public SchemaIndexProvider.Descriptor indexGetProviderDescriptor(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public IndexCapability indexGetCapability(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public PopulationProgress indexGetPopulationProgress(LabelSchemaDescriptor var1) throws IndexNotFoundKernelException;

    public String indexGetFailure(LabelSchemaDescriptor var1) throws IndexNotFoundKernelException;

    public int labelGetForName(String var1);

    public String labelGetName(int var1) throws LabelNotFoundKernelException;

    public int propertyKeyGetForName(String var1);

    public int propertyKeyGetOrCreateForName(String var1);

    public String propertyKeyGetName(int var1) throws PropertyKeyIdNotFoundKernelException;

    public Iterator<Token> propertyKeyGetAllTokens();

    public Iterator<Token> labelsGetAllTokens();

    public Iterator<Token> relationshipTypeGetAllTokens();

    public int relationshipTypeGetForName(String var1);

    public String relationshipTypeGetName(int var1) throws RelationshipTypeIdNotFoundKernelException;

    public int labelGetOrCreateForName(String var1) throws TooManyLabelsException;

    public int relationshipTypeGetOrCreateForName(String var1);

    public <EXCEPTION extends Exception> void relationshipVisit(long var1, RelationshipVisitor<EXCEPTION> var3) throws EntityNotFoundException, EXCEPTION;

    public PrimitiveLongIterator nodesGetAll();

    public RelationshipIterator relationshipsGetAll();

    public Cursor<RelationshipItem> nodeGetRelationships(StorageStatement var1, NodeItem var2, Direction var3);

    public Cursor<RelationshipItem> nodeGetRelationships(StorageStatement var1, NodeItem var2, Direction var3, IntPredicate var4);

    public Cursor<PropertyItem> nodeGetProperties(StorageStatement var1, NodeItem var2, AssertOpen var3);

    public Cursor<PropertyItem> nodeGetProperty(StorageStatement var1, NodeItem var2, int var3, AssertOpen var4);

    public Cursor<PropertyItem> relationshipGetProperties(StorageStatement var1, RelationshipItem var2, AssertOpen var3);

    public Cursor<PropertyItem> relationshipGetProperty(StorageStatement var1, RelationshipItem var2, int var3, AssertOpen var4);

    public void releaseNode(long var1);

    public void releaseRelationship(long var1);

    public long countsForNode(int var1);

    public long countsForRelationship(int var1, int var2, int var3);

    public long indexSize(LabelSchemaDescriptor var1) throws IndexNotFoundKernelException;

    public double indexUniqueValuesPercentage(LabelSchemaDescriptor var1) throws IndexNotFoundKernelException;

    public long nodesGetCount();

    public long relationshipsGetCount();

    public int labelCount();

    public int propertyKeyCount();

    public int relationshipTypeCount();

    public Register.DoubleLongRegister indexUpdatesAndSize(LabelSchemaDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public Register.DoubleLongRegister indexSample(LabelSchemaDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public boolean nodeExists(long var1);

    public PrimitiveIntSet relationshipTypes(StorageStatement var1, NodeItem var2);

    public void degrees(StorageStatement var1, NodeItem var2, DegreeVisitor var3);

    public int degreeRelationshipsInGroup(StorageStatement var1, long var2, long var4, Direction var6, Integer var7);

    public <T> T getOrCreateSchemaDependantState(Class<T> var1, Function<StoreReadLayer, T> var2);
}

