/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.recovery.LogTailScanner;

public class LogVersionUpgradeChecker {
    private LogVersionUpgradeChecker() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static void check(LogTailScanner tailScanner, Config config) throws UpgradeNotAllowedByConfigurationException {
        LogEntryVersion latestLogEntryVersion;
        if (!config.get(GraphDatabaseSettings.allow_upgrade).booleanValue() && (latestLogEntryVersion = tailScanner.getTailInformation().latestLogEntryVersion) != null && LogEntryVersion.moreRecentVersionExists(latestLogEntryVersion)) {
            String message = "The version you're upgrading to is using a new transaction log format. This is a non-reversible upgrade and you wont be able to downgrade after starting";
            throw new UpgradeNotAllowedByConfigurationException(message);
        }
    }
}

