/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.neo4j.concurrent.AsyncApply;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.OnlineIndexUpdates;
import org.neo4j.storageengine.api.CommandsToApply;

public class IndexBatchTransactionApplier
extends BatchTransactionApplier.Adapter {
    private final IndexingService indexingService;
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;
    private final WorkSync<IndexingUpdateService, IndexUpdatesWork> indexUpdatesSync;
    private final SingleTransactionApplier transactionApplier;
    private final PropertyPhysicalToLogicalConverter indexUpdateConverter;
    private List<NodeLabelUpdate> labelUpdates;
    private IndexUpdates indexUpdates;

    public IndexBatchTransactionApplier(IndexingService indexingService, WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync, WorkSync<IndexingUpdateService, IndexUpdatesWork> indexUpdatesSync, NodeStore nodeStore, PropertyPhysicalToLogicalConverter indexUpdateConverter) {
        this.indexingService = indexingService;
        this.labelScanStoreSync = labelScanStoreSync;
        this.indexUpdatesSync = indexUpdatesSync;
        this.indexUpdateConverter = indexUpdateConverter;
        this.transactionApplier = new SingleTransactionApplier(nodeStore);
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        return this.transactionApplier;
    }

    private void applyPendingLabelAndIndexUpdates() throws IOException {
        AsyncApply labelUpdatesApply = null;
        if (this.labelUpdates != null) {
            labelUpdatesApply = this.labelScanStoreSync.applyAsync((Work)new LabelUpdateWork(this.labelUpdates));
            this.labelUpdates = null;
        }
        if (this.indexUpdates != null && this.indexUpdates.hasUpdates()) {
            try {
                this.indexUpdatesSync.apply((Work)new IndexUpdatesWork(this.indexUpdates));
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush index updates", e);
            }
            this.indexUpdates = null;
        }
        if (labelUpdatesApply != null) {
            try {
                labelUpdatesApply.await();
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush label updates", e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.applyPendingLabelAndIndexUpdates();
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final NodeStore nodeStore;
        private final NodePropertyCommandsExtractor indexUpdatesExtractor = new NodePropertyCommandsExtractor();
        private List<IndexRule> createdIndexes;

        SingleTransactionApplier(NodeStore nodeStore) {
            this.nodeStore = nodeStore;
        }

        @Override
        public void close() throws Exception {
            if (this.indexUpdatesExtractor.containsAnyNodeOrPropertyUpdate()) {
                this.indexUpdates().feed(this.indexUpdatesExtractor.propertyCommandsByNodeIds(), this.indexUpdatesExtractor.nodeCommandsById());
                this.indexUpdatesExtractor.close();
            }
            if (this.createdIndexes != null) {
                IndexBatchTransactionApplier.this.indexingService.createIndexes(this.createdIndexes.toArray(new IndexRule[this.createdIndexes.size()]));
                this.createdIndexes = null;
            }
        }

        private IndexUpdates indexUpdates() {
            if (IndexBatchTransactionApplier.this.indexUpdates == null) {
                IndexBatchTransactionApplier.this.indexUpdates = new OnlineIndexUpdates(this.nodeStore, IndexBatchTransactionApplier.this.indexingService, IndexBatchTransactionApplier.this.indexUpdateConverter);
            }
            return IndexBatchTransactionApplier.this.indexUpdates;
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            NodeRecord before = (NodeRecord)command.getBefore();
            NodeRecord after = (NodeRecord)command.getAfter();
            NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
            NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
            if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
                long[] labelsBefore = labelFieldBefore.getIfLoaded();
                long[] labelsAfter = labelFieldAfter.getIfLoaded();
                if (labelsBefore != null && labelsAfter != null) {
                    if (IndexBatchTransactionApplier.this.labelUpdates == null) {
                        IndexBatchTransactionApplier.this.labelUpdates = new ArrayList();
                    }
                    IndexBatchTransactionApplier.this.labelUpdates.add(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter));
                }
            }
            return this.indexUpdatesExtractor.visitNodeCommand(command);
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            return this.indexUpdatesExtractor.visitPropertyCommand(command);
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            if (command.getSchemaRule() instanceof IndexRule) {
                IndexBatchTransactionApplier.this.applyPendingLabelAndIndexUpdates();
                switch (command.getMode()) {
                    case UPDATE: {
                        if (!((IndexRule)command.getSchemaRule()).canSupportUniqueConstraint()) break;
                        try {
                            IndexBatchTransactionApplier.this.indexingService.activateIndex(command.getSchemaRule().getId());
                            break;
                        }
                        catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                            throw new IllegalStateException("Unable to enable constraint, backing index is not online.", (Throwable)e);
                        }
                    }
                    case CREATE: {
                        this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                        this.createdIndexes.add((IndexRule)command.getSchemaRule());
                        break;
                    }
                    case DELETE: {
                        IndexBatchTransactionApplier.this.indexingService.dropIndex((IndexRule)command.getSchemaRule());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(command.getMode().name());
                    }
                }
            }
            return false;
        }
    }
}

