/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanAsInputIterator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.CustomIOConfigValidator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.BatchImporterFactory;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;

public class StoreMigrator
extends AbstractStoreMigrationParticipant {
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    public static final String CUSTOM_IO_EXCEPTION_MESSAGE = "Migrating this version is not supported for custom IO configurations.";
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (versionToMigrateFrom.equals(StandardV2_3.STORE_VERSION)) {
            CustomIOConfigValidator.assertCustomIOConfigNotUsed(this.config, CUSTOM_IO_EXCEPTION_MESSAGE);
        }
        File neoStore = new File(storeDir, "neostore");
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, storeDir, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, storeDir, lastTxId);
        this.writeLastTxInformation(migrationDir, lastTxInfo);
        this.writeLastTxLogPosition(migrationDir, lastTxLogPosition);
        if (versionToMigrateFrom.equals("vE.H.0")) {
            versionToMigrateFrom = "vE.H.0b";
        }
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo);
        if (FormatFamily.isHigherFamilyFormat(newFormat, oldFormat) || FormatFamily.isSameFamily(oldFormat, newFormat) && this.isDifferentCapabilities(oldFormat, newFormat)) {
            this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), progressReporter, oldFormat, newFormat);
        }
        LogPosition logPosition = this.readLastTxLogPosition(migrationDir);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir, versionToMigrateTo, logPosition);
    }

    private boolean isDifferentCapabilities(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasSameCapabilities(newFormat, CapabilityType.FORMAT);
    }

    void writeLastTxInformation(File migrationDir, TransactionId txInfo) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(File migrationDir, LogPosition lastTxLogPosition) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), 3);
        return new TransactionId(counters[0], counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, File file, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(file, StandardCharsets.UTF_8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, File file, int numberOfCounters) throws IOException {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static File lastTxInformationFile(File migrationDir) {
        return new File(migrationDir, "lastxinformation");
    }

    private static File lastTxLogPositionFile(File migrationDir) {
        return new File(migrationDir, "lastxlogposition");
    }

    TransactionId extractTransactionIdInformation(File neoStore, File storeDir, long lastTransactionId) throws IOException {
        long checksum = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP);
        if (checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(lastTransactionId, checksum, commitTimestamp);
        }
        return this.specificTransactionInformationSupplier(lastTransactionId);
    }

    private TransactionId specificTransactionInformationSupplier(long lastTransactionId) {
        return lastTransactionId == 1L ? new TransactionId(lastTransactionId, 0L, 0L) : new TransactionId(lastTransactionId, 1L, 1L);
    }

    LogPosition extractTransactionLogPosition(File neoStore, File storeDir, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder(storeDir, this.fileSystem, this.pageCache).withConfig(this.config).build();
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getHighestLogFile());
        return new LogPosition(logVersion, offset);
    }

    private void migrateWithBatchImporter(final File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, ProgressReporter progressReporter, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.prepareBatchImportMigration(storeDir, migrationDir, oldFormat, newFormat);
        boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        File badFile = new File(storeDir, "bad.log");
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, storeDir);
             RecordCursors nodeInputCursors = new RecordCursors(legacyStore);
             RecordCursors relationshipInputCursors = new RecordCursors(legacyStore);
             BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));){
            Configuration.Overridden importConfig = new Configuration.Overridden(this.config){

                @Override
                public boolean parallelRecordReadsWhenWriting() {
                    return FileUtils.highIODevice((Path)storeDir.toPath(), (boolean)super.parallelRecordReadsWhenWriting());
                }
            };
            AdditionalInitialIds additionalInitialIds = this.readAdditionalIds(lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
            BatchImporter importer = BatchImporterFactory.withHighestPriority().instantiate(migrationDir.getAbsoluteFile(), this.fileSystem, this.pageCache, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(this.migrationBatchImporterMonitor(legacyStore, progressReporter, importConfig), importConfig), additionalInitialIds, this.config, newFormat, ImportLogic.NO_MONITOR);
            InputIterable nodes = InputIterable.replayable(() -> this.legacyNodesAsInput(legacyStore, requiresPropertyMigration, nodeInputCursors));
            InputIterable relationships = InputIterable.replayable(() -> this.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration, relationshipInputCursors));
            long propertyStoreSize = StoreMigrator.storeSize(legacyStore.getPropertyStore()) / 2L + StoreMigrator.storeSize(legacyStore.getPropertyStore().getStringStore()) / 2L + StoreMigrator.storeSize(legacyStore.getPropertyStore().getArrayStore()) / 2L;
            Input.Estimates estimates = Inputs.knownEstimates(legacyStore.getNodeStore().getNumberOfIdsInUse(), legacyStore.getRelationshipStore().getNumberOfIdsInUse(), legacyStore.getPropertyStore().getNumberOfIdsInUse(), legacyStore.getPropertyStore().getNumberOfIdsInUse(), propertyStoreSize / 2L, propertyStoreSize / 2L, 0L);
            importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), Collectors.badCollector(badOutput, 0L), estimates));
            ArrayList<StoreFile> storesToDeleteFromMigratedDirectory = new ArrayList<StoreFile>();
            storesToDeleteFromMigratedDirectory.add(StoreFile.NEO_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE));
            }
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, storesToDeleteFromMigratedDirectory, true, null, StoreFileType.values());
            try {
                Predicate<FileHandle> fileHandlePredicate = fileHandle -> storesToDeleteFromMigratedDirectory.stream().anyMatch(storeFile -> storeFile.fileName(StoreFileType.STORE).equals(fileHandle.getFile().getName()));
                this.pageCache.getCachedFileSystem().streamFilesRecursive(migrationDir).filter(fileHandlePredicate).forEach(FileHandle.HANDLE_DELETE);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        return store.getNumberOfIdsInUse() * (long)store.getRecordSize();
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, File storeDir) {
        return new StoreFactory(storeDir, this.config, new ReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, format, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.createStore(migrationDir, newFormat);
        StoreFile[] storesFilesToMigrate = new StoreFile[]{StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.NODE_LABEL_STORE};
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            for (StoreFile file : storesFilesToMigrate) {
                File fromPath = new File(storeDir, file.fileName(StoreFileType.STORE));
                File toPath = new File(migrationDir, file.fileName(StoreFileType.STORE));
                try {
                    this.copyWithPageCache(fromPath, toPath);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Arrays.asList(storesFilesToMigrate), true, ExistingTargetStrategy.FAIL, StoreFileType.ID);
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL, StoreType.SCHEMA};
            SilentProgressReporter progressReporter = SilentProgressReporter.INSTANCE;
            migrator.migrate(storeDir, oldFormat, migrationDir, newFormat, progressReporter, storesToMigrate, StoreType.NODE);
        }
    }

    private void createStore(File migrationDir, RecordFormats newFormat) {
        ReadOnlyIdGeneratorFactory idGeneratorFactory = new ReadOnlyIdGeneratorFactory(this.fileSystem);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(migrationDir, this.config, idGeneratorFactory, this.pageCache, this.fileSystem, newFormat, (LogProvider)logProvider);
        try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
            neoStores.getLabelTokenStore();
            neoStores.getNodeStore();
            neoStores.getPropertyStore();
            neoStores.getRelationshipGroupStore();
            neoStores.getRelationshipStore();
            neoStores.getSchemaStore();
        }
    }

    private AdditionalInitialIds readAdditionalIds(final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) throws IOException {
        return new AdditionalInitialIds(){

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, ProgressReporter progressReporter, Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressReporter);
    }

    private InputIterator legacyRelationshipsAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        RelationshipStore store = legacyStore.getRelationshipStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterator<RelationshipRecord>((RecordStore)store){

            @Override
            protected boolean visitRecord(RelationshipRecord record, InputEntityVisitor visitor) {
                visitor.startId(record.getFirstNode());
                visitor.endId(record.getSecondNode());
                visitor.type(record.getType());
                propertyDecorator.accept(visitor, record);
                return true;
            }
        };
    }

    private InputIterator legacyNodesAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        NodeStore store = legacyStore.getNodeStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterator<NodeRecord>((RecordStore)store){

            @Override
            protected boolean visitRecord(NodeRecord record, InputEntityVisitor visitor) {
                visitor.id(record.getId());
                visitor.labelField(record.getLabelField());
                propertyDecorator.accept(visitor, record);
                return true;
            }
        };
    }

    private <RECORD extends PrimitiveRecord> BiConsumer<InputEntityVisitor, RECORD> propertyDecorator(boolean requiresPropertyMigration, RecordCursors cursors) {
        if (!requiresPropertyMigration) {
            return (entity, record) -> entity.propertyId(record.getNextProp());
        }
        StorePropertyCursor cursor = new StorePropertyCursor(cursors, ignored -> {});
        return (entity, record) -> {
            cursor.init(record.getNextProp(), LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
            while (cursor.next()) {
                entity.property(cursor.propertyKeyId(), cursor.value().asObject());
            }
            cursor.close();
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, StoreFile.currentStoreFiles(), true, ExistingTargetStrategy.OVERWRITE, StoreFileType.values());
        try {
            Iterable fileHandles = this.pageCache.getCachedFileSystem().streamFilesRecursive(migrationDir)::iterator;
            for (FileHandle fh : fileHandles) {
                Predicate<StoreFile> predicate = storeFile -> storeFile.fileName(StoreFileType.STORE).equals(fh.getFile().getName());
                if (!StreamSupport.stream(StoreFile.currentStoreFiles().spliterator(), false).anyMatch(predicate)) continue;
                Optional optionalPagedFile = this.pageCache.getExistingMapping(fh.getFile());
                if (optionalPagedFile.isPresent()) {
                    ((PagedFile)optionalPagedFile.get()).close();
                }
                fh.rename(new File(storeDir, fh.getFile().getName()), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir, String versionToMigrateTo, LogPosition lastClosedTxLogPosition) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        File migrationDirNeoStore = new File(migrationDir, "neostore");
        this.copyWithPageCache(storeDirNeoStore, migrationDirNeoStore);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        TransactionId lastTxInfo = this.readLastTxInformation(migrationDir);
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTxLogPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTxLogPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, migrationDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo));
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private void copyWithPageCache(File sourceFile, File targetFile) throws IOException {
        int pageSize = this.pageCache.pageSize();
        try (PagedFile fromFile = this.pageCache.map(sourceFile, pageSize, new OpenOption[0]);
             PagedFile toFile = this.pageCache.map(targetFile, pageSize, new OpenOption[]{StandardOpenOption.CREATE});
             PageCursor fromCursor = fromFile.io(0L, 1);
             PageCursor toCursor = toFile.io(0L, 2);){
            while (fromCursor.next()) {
                toCursor.next();
                do {
                    fromCursor.copyTo(0, toCursor, 0, pageSize);
                } while (fromCursor.shouldRetry());
            }
        }
    }

    private class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final ProgressReporter progressReporter;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, ProgressReporter progressReporter) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressReporter = progressReporter;
            this.progressReporter.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressReporter.progress(progress);
        }
    }
}

