/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.store.PropertyUtil;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class AllStoreHolder
extends Read {
    private final StorageStatement.Nodes nodes;
    private final StorageStatement.Groups groups;
    private final StorageStatement.Properties properties;
    private final StorageStatement.Relationships relationships;
    private final StorageStatement statement;
    private final StoreReadLayer storeReadLayer;
    private final ExplicitIndexStore explicitIndexStore;
    private final Suppliers.Lazy<ExplicitIndexTransactionState> explicitIndexes;

    public AllStoreHolder(StorageEngine engine, StorageStatement statement, KernelTransactionImplementation ktx, Cursors cursors, ExplicitIndexStore explicitIndexStore) {
        super(cursors, ktx);
        this.storeReadLayer = engine.storeReadLayer();
        this.statement = statement;
        this.explicitIndexes = Suppliers.lazySingleton(ktx::explicitIndexTxState);
        this.nodes = statement.nodes();
        this.relationships = statement.relationships();
        this.groups = statement.groups();
        this.properties = statement.properties();
        this.explicitIndexStore = explicitIndexStore;
    }

    public boolean nodeExists(long reference) {
        this.ktx.assertOpen();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        return this.storeReadLayer.nodeExists(reference);
    }

    @Override
    long graphPropertiesReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    IndexReader indexReader(IndexReference index) throws IndexNotFoundKernelException {
        IndexDescriptor indexDescriptor = index.isUnique() ? IndexDescriptorFactory.uniqueForLabel(index.label(), index.properties()) : IndexDescriptorFactory.forLabel(index.label(), index.properties());
        return this.statement.getIndexReader(indexDescriptor);
    }

    @Override
    LabelScanReader labelScanReader() {
        return this.statement.getLabelScanReader();
    }

    @Override
    ExplicitIndex explicitNodeIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).nodeChanges(indexName);
    }

    @Override
    ExplicitIndex explicitRelationshipIndex(String indexName) throws ExplicitIndexNotFoundKernelException {
        return ((ExplicitIndexTransactionState)this.explicitIndexes.get()).relationshipChanges(indexName);
    }

    @Override
    public CapableIndexReference index(int label, int ... properties) {
        this.ktx.assertOpen();
        IndexDescriptor indexDescriptor = this.storeReadLayer.indexGetForSchema(new LabelSchemaDescriptor(label, properties));
        if (indexDescriptor == null) {
            return CapableIndexReference.NO_INDEX;
        }
        return this.indexGetCapability(indexDescriptor);
    }

    CapableIndexReference indexGetCapability(IndexDescriptor indexDescriptor) {
        boolean unique = indexDescriptor.type() == IndexDescriptor.Type.UNIQUE;
        try {
            IndexCapability indexCapability = this.storeReadLayer.indexGetCapability(indexDescriptor);
            return new DefaultCapableIndexReference(unique, indexCapability, indexDescriptor.schema().getLabelId(), indexDescriptor.schema().getPropertyIds());
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Could not find capability for index " + indexDescriptor, (Throwable)((Object)e));
        }
    }

    InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (this.ktx.hasTxStateWithChanges() && this.checkIndexState(descriptor, this.ktx.txState().indexDiffSetsByLabel(descriptor.schema().getLabelId()))) {
            return InternalIndexState.POPULATING;
        }
        return this.storeReadLayer.indexGetState(descriptor);
    }

    private boolean checkIndexState(IndexDescriptor index, ReadableDiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(index)) {
            return true;
        }
        if (diffSet.isRemoved(index)) {
            throw new IndexNotFoundKernelException(String.format("Index on %s has been dropped in this transaction.", index.userDescription(SchemaUtil.idTokenNameLookup)));
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        this.sharedOptimisticLock(descriptor.keyType(), descriptor.keyId());
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetForSchema(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForSchema(descriptor).apply(constraints);
        }
        return constraints;
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        SchemaDescriptor schema = descriptor.schema();
        this.sharedOptimisticLock(schema.keyType(), schema.keyId());
        this.ktx.assertOpen();
        boolean inStore = this.storeReadLayer.constraintExists(descriptor);
        if (this.ktx.hasTxStateWithChanges()) {
            ReadableDiffSets<ConstraintDescriptor> diffSet = this.ktx.txState().constraintsChangesForSchema(descriptor.schema());
            return diffSet.isAdded(descriptor) || inStore && !diffSet.isRemoved(descriptor);
        }
        return inStore;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.sharedOptimisticLock(ResourceTypes.LABEL, labelId);
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetForLabel(labelId);
        if (this.ktx.hasTxStateWithChanges()) {
            return this.ktx.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        Iterator<ConstraintDescriptor> constraints = this.storeReadLayer.constraintsGetAll();
        if (this.ktx.hasTxStateWithChanges()) {
            constraints = this.ktx.txState().constraintsChanges().apply(constraints);
        }
        return Iterators.map(constraintDescriptor -> {
            SchemaDescriptor schema = constraintDescriptor.schema();
            this.ktx.locks().pessimistic().acquireShared(this.ktx.lockTracer(), schema.keyType(), schema.keyId());
            return constraintDescriptor;
        }, constraints);
    }

    @Override
    PageCursor nodePage(long reference) {
        return this.nodes.openPageCursorForReading(reference);
    }

    @Override
    PageCursor relationshipPage(long reference) {
        return this.relationships.openPageCursorForReading(reference);
    }

    @Override
    PageCursor groupPage(long reference) {
        return this.groups.openPageCursorForReading(reference);
    }

    @Override
    PageCursor propertyPage(long reference) {
        return this.properties.openPageCursorForReading(reference);
    }

    @Override
    PageCursor stringPage(long reference) {
        return this.properties.openStringPageCursor(reference);
    }

    @Override
    PageCursor arrayPage(long reference) {
        return this.properties.openArrayPageCursor(reference);
    }

    @Override
    RecordCursor<DynamicRecord> labelCursor() {
        return this.nodes.newLabelCursor();
    }

    @Override
    void node(NodeRecord record, long reference, PageCursor pageCursor) {
        this.nodes.getRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void relationship(RelationshipRecord record, long reference, PageCursor pageCursor) {
        this.relationships.getRecordByCursor(reference, record, RecordLoad.CHECK, pageCursor);
    }

    @Override
    void property(PropertyRecord record, long reference, PageCursor pageCursor) {
        this.properties.getRecordByCursor(reference, record, RecordLoad.FORCE, pageCursor);
    }

    @Override
    void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groups.getRecordByCursor(reference, record, RecordLoad.NORMAL, page);
    }

    @Override
    long nodeHighMark() {
        return this.nodes.getHighestPossibleIdInUse();
    }

    @Override
    long relationshipHighMark() {
        return this.relationships.getHighestPossibleIdInUse();
    }

    @Override
    TextValue string(PropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadString(reference, cursor.buffer, page);
        buffer.flip();
        return Values.stringValue((String)UTF8.decode((byte[])buffer.array(), (int)0, (int)buffer.limit()));
    }

    @Override
    ArrayValue array(PropertyCursor cursor, long reference, PageCursor page) {
        ByteBuffer buffer = cursor.buffer = this.properties.loadArray(reference, cursor.buffer, page);
        buffer.flip();
        return PropertyUtil.readArrayFromBuffer(buffer);
    }

    boolean nodeExistsInStore(long id) {
        return this.storeReadLayer.nodeExists(id);
    }

    void getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    void getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfig) {
        this.explicitIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeReadLayer.indexGetFailure(descriptor.schema());
    }
}

