/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.impl.api.state.PropertyContainerStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

public class NodeStateImpl
extends PropertyContainerStateImpl
implements NodeState {
    private DiffSets<Integer> labelDiffSets;
    private RelationshipChangesForNode relationshipsAdded;
    private RelationshipChangesForNode relationshipsRemoved;
    private Set<PrimitiveLongDiffSets> indexDiffs;
    private final TxState state;

    NodeStateImpl(long id, TxState state) {
        super(id);
        this.state = state;
    }

    @Override
    public ReadableDiffSets<Integer> labelDiffSets() {
        return ReadableDiffSets.Empty.ifNull(this.labelDiffSets);
    }

    DiffSets<Integer> getOrCreateLabelDiffSets() {
        if (null == this.labelDiffSets) {
            this.labelDiffSets = new DiffSets();
        }
        return this.labelDiffSets;
    }

    public void addRelationship(long relId, int typeId, Direction direction) {
        if (!this.hasAddedRelationships()) {
            this.relationshipsAdded = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD, this.state);
        }
        this.relationshipsAdded.addRelationship(relId, typeId, direction);
    }

    public void removeRelationship(long relId, int typeId, Direction direction) {
        if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
            return;
        }
        if (!this.hasRemovedRelationships()) {
            this.relationshipsRemoved = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE, this.state);
        }
        this.relationshipsRemoved.addRelationship(relId, typeId, direction);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.relationshipsAdded != null) {
            this.relationshipsAdded.clear();
        }
        if (this.relationshipsRemoved != null) {
            this.relationshipsRemoved.clear();
        }
        if (this.labelDiffSets != null) {
            this.labelDiffSets.clear();
        }
        if (this.indexDiffs != null) {
            this.indexDiffs.clear();
        }
    }

    @Override
    public int augmentDegree(Direction direction, int degree) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree);
        }
        return degree;
    }

    @Override
    public int augmentDegree(Direction direction, int degree, int typeId) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    @Override
    public void accept(NodeState.Visitor visitor) throws ConstraintValidationException {
        super.accept(visitor);
        if (this.labelDiffSets != null) {
            visitor.visitLabelChanges(this.getId(), this.labelDiffSets.getAdded(), this.labelDiffSets.getRemoved());
        }
    }

    private boolean hasAddedRelationships() {
        return this.relationshipsAdded != null;
    }

    private boolean hasRemovedRelationships() {
        return this.relationshipsRemoved != null;
    }

    @Override
    public PrimitiveIntSet relationshipTypes() {
        if (this.hasAddedRelationships()) {
            return this.relationshipsAdded.relationshipTypes();
        }
        return Primitive.intSet();
    }

    void addIndexDiff(PrimitiveLongDiffSets diff) {
        if (this.indexDiffs == null) {
            this.indexDiffs = new HashSet<PrimitiveLongDiffSets>();
        }
        this.indexDiffs.add(diff);
    }

    void removeIndexDiff(PrimitiveLongDiffSets diff) {
        if (this.indexDiffs != null) {
            this.indexDiffs.remove(diff);
        }
    }

    void clearIndexDiffs(long nodeId) {
        if (this.indexDiffs != null) {
            for (PrimitiveLongDiffSets diff : this.indexDiffs) {
                if (diff.getAdded().contains(nodeId)) {
                    diff.remove(nodeId);
                    continue;
                }
                if (!diff.getRemoved().contains(nodeId)) continue;
                diff.add(nodeId);
            }
        }
    }

    @Override
    public boolean hasRelationshipChanges() {
        return this.hasAddedRelationships() || this.hasRemovedRelationships();
    }

    @Override
    public PrimitiveLongIterator getAddedRelationships(Direction direction) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction) : PrimitiveLongCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongIterator getAddedRelationships(Direction direction, int[] relTypes) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relTypes) : PrimitiveLongCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongIterator getAddedRelationships() {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships() : PrimitiveLongCollections.emptyIterator();
    }

    @Override
    public PrimitiveLongIterator getAddedRelationships(RelationshipDirection direction, int relType) {
        return this.relationshipsAdded != null ? this.relationshipsAdded.getRelationships(direction, relType) : PrimitiveLongCollections.emptyIterator();
    }

    public static abstract class Defaults
    extends StateDefaults<NodeState, NodeStateImpl> {
        private static final NodeState DEFAULT = new NodeState(){

            @Override
            public Iterator<StorageProperty> addedProperties() {
                return Collections.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> changedProperties() {
                return Collections.emptyIterator();
            }

            @Override
            public Iterator<Integer> removedProperties() {
                return Collections.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> addedAndChangedProperties() {
                return Collections.emptyIterator();
            }

            @Override
            public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> iterator) {
                return iterator;
            }

            @Override
            public void accept(PropertyContainerState.Visitor visitor) throws ConstraintValidationException {
            }

            @Override
            public ReadableDiffSets<Integer> labelDiffSets() {
                return ReadableDiffSets.Empty.instance();
            }

            @Override
            public int augmentDegree(Direction direction, int degree) {
                return degree;
            }

            @Override
            public int augmentDegree(Direction direction, int degree, int typeId) {
                return degree;
            }

            @Override
            public void accept(NodeState.Visitor visitor) {
            }

            @Override
            public PrimitiveIntSet relationshipTypes() {
                return Primitive.intSet();
            }

            @Override
            public long getId() {
                throw new UnsupportedOperationException("id not defined");
            }

            @Override
            public boolean hasPropertyChanges() {
                return false;
            }

            @Override
            public boolean hasRelationshipChanges() {
                return false;
            }

            @Override
            public StorageProperty getChangedProperty(int propertyKeyId) {
                return null;
            }

            @Override
            public StorageProperty getAddedProperty(int propertyKeyId) {
                return null;
            }

            @Override
            public boolean isPropertyChangedOrRemoved(int propertyKey) {
                return false;
            }

            @Override
            public boolean isPropertyRemoved(int propertyKeyId) {
                return false;
            }

            @Override
            public PrimitiveLongIterator getAddedRelationships(Direction direction) {
                return null;
            }

            @Override
            public PrimitiveLongIterator getAddedRelationships(Direction direction, int[] relTypes) {
                return null;
            }

            @Override
            public PrimitiveLongIterator getAddedRelationships() {
                return null;
            }

            @Override
            public PrimitiveLongIterator getAddedRelationships(RelationshipDirection direction, int relType) {
                return null;
            }
        };

        @Override
        final NodeStateImpl createValue(long id, TxState state) {
            return new NodeStateImpl(id, state);
        }

        @Override
        final NodeState defaultValue() {
            return DEFAULT;
        }
    }
}

