/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.Set;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class KernelTransactionTimeoutMonitor
implements Runnable {
    private final KernelTransactions kernelTransactions;
    private final Clock clock;
    private final Log log;

    public KernelTransactionTimeoutMonitor(KernelTransactions kernelTransactions, Clock clock, LogService logService) {
        this.kernelTransactions = kernelTransactions;
        this.clock = clock;
        this.log = logService.getInternalLog(KernelTransactionTimeoutMonitor.class);
    }

    @Override
    public synchronized void run() {
        Set<KernelTransactionHandle> activeTransactions = this.kernelTransactions.activeTransactions();
        long now = this.clock.millis();
        for (KernelTransactionHandle activeTransaction : activeTransactions) {
            long transactionTimeoutMillis = activeTransaction.timeoutMillis();
            if (transactionTimeoutMillis <= 0L || !this.isTransactionExpired(activeTransaction, now, transactionTimeoutMillis) || !activeTransaction.markForTermination((Status)Status.Transaction.TransactionTimedOut)) continue;
            this.log.warn("Transaction %s timeout.", new Object[]{activeTransaction});
        }
    }

    private boolean isTransactionExpired(KernelTransactionHandle activeTransaction, long nowMillis, long transactionTimeoutMillis) {
        return nowMillis > activeTransaction.startTime() + transactionTimeoutMillis;
    }
}

