/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.io.ByteUnit;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvGroupInputIterator;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInputIterator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.values.storable.Value;

public class CsvInput
implements Input {
    private static final long ESTIMATE_SAMPLE_SIZE = ByteUnit.mebiBytes((long)1L);
    private final Iterable<DataFactory> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final Configuration config;
    private final Collector badCollector;
    private final Groups groups;

    public CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, Collector badCollector) {
        this(nodeDataFactory, nodeHeaderFactory, relationshipDataFactory, relationshipHeaderFactory, idType, config, badCollector, new Groups());
    }

    CsvInput(Iterable<DataFactory> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, Collector badCollector, Groups groups) {
        CsvInput.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.config = config;
        this.badCollector = badCollector;
        this.groups = groups;
        this.verifyHeaders();
    }

    private void verifyHeaders() {
        try {
            Throwable throwable;
            CharSeeker dataStream;
            for (DataFactory dataFactory : this.nodeDataFactory) {
                dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(dataFactory.create(this.config).stream()), (org.neo4j.csv.reader.Configuration)this.config, (boolean)true);
                throwable = null;
                try {
                    this.nodeHeaderFactory.create(dataStream, this.config, this.idType, this.groups);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataStream == null) continue;
                    if (throwable != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataStream.close();
                }
            }
            for (DataFactory dataFactory : this.relationshipDataFactory) {
                dataStream = CharSeekers.charSeeker((CharReadable)new MultiReadable(dataFactory.create(this.config).stream()), (org.neo4j.csv.reader.Configuration)this.config, (boolean)true);
                throwable = null;
                try {
                    this.relationshipHeaderFactory.create(dataStream, this.config, this.idType, this.groups);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dataStream == null) continue;
                    if (throwable != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    dataStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        CsvInput.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private static void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    @Override
    public InputIterable nodes() {
        return InputIterable.replayable(() -> this.stream(this.nodeDataFactory, this.nodeHeaderFactory));
    }

    @Override
    public InputIterable relationships() {
        return InputIterable.replayable(() -> this.stream(this.relationshipDataFactory, this.relationshipHeaderFactory));
    }

    private InputIterator stream(Iterable<DataFactory> data, Header.Factory headerFactory) {
        return new CsvGroupInputIterator(data.iterator(), headerFactory, this.idType, this.config, this.badCollector, this.groups);
    }

    @Override
    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return this.idType.idMapper(numberArrayFactory, this.groups);
    }

    @Override
    public Collector badCollector() {
        return this.badCollector;
    }

    @Override
    public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) throws IOException {
        long[] nodeSample = this.sample(this.nodeDataFactory, this.nodeHeaderFactory, valueSizeCalculator, node -> node.labels().length);
        long[] relationshipSample = this.sample(this.relationshipDataFactory, this.relationshipHeaderFactory, valueSizeCalculator, entity -> 0);
        return Inputs.knownEstimates(nodeSample[0], relationshipSample[0], nodeSample[1], relationshipSample[1], nodeSample[2], relationshipSample[2], nodeSample[3]);
    }

    private long[] sample(Iterable<DataFactory> dataFactories, Header.Factory headerFactory, ToIntFunction<Value[]> valueSizeCalculator, ToIntFunction<InputEntity> additionalCalculator) throws IOException {
        long[] estimates = new long[4];
        try (CsvInputChunkProxy chunk = new CsvInputChunkProxy();){
            int groupId = 0;
            for (DataFactory dataFactory : dataFactories) {
                ++groupId;
                Header header = null;
                Data data = dataFactory.create(this.config);
                RawIterator<CharReadable, IOException> sources = data.stream();
                while (sources.hasNext()) {
                    CharReadable source = (CharReadable)sources.next();
                    Throwable throwable = null;
                    try {
                        if (header == null) {
                            header = CsvInputIterator.extractHeader(source, headerFactory, this.idType, this.config, this.groups);
                        }
                        CsvInputIterator iterator = new CsvInputIterator(source, data.decorator(), header, this.config, this.idType, Collector.EMPTY, CsvGroupInputIterator.extractors(this.config), groupId);
                        Throwable throwable2 = null;
                        try {
                            InputEntity entity = new InputEntity();
                            Throwable throwable3 = null;
                            try {
                                int entities = 0;
                                int properties = 0;
                                int propertySize = 0;
                                int additional = 0;
                                while (iterator.position() < ESTIMATE_SAMPLE_SIZE && iterator.next(chunk)) {
                                    while (chunk.next(entity)) {
                                        properties += entity.propertyCount();
                                        propertySize += Inputs.calculatePropertySize(entity, valueSizeCalculator);
                                        additional += additionalCalculator.applyAsInt(entity);
                                        ++entities;
                                    }
                                }
                                long entityCount = entities > 0 ? (long)((double)source.length() / (double)iterator.position() * (double)entities) : 0L;
                                estimates[0] = estimates[0] + entityCount;
                                estimates[1] = (long)((double)estimates[1] + (double)properties / (double)entities * (double)entityCount);
                                estimates[2] = (long)((double)estimates[2] + (double)propertySize / (double)entities * (double)entityCount);
                                estimates[3] = (long)((double)estimates[3] + (double)additional / (double)entities * (double)entityCount);
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (entity == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        entity.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                entity.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (iterator == null) continue;
                            if (throwable2 != null) {
                                try {
                                    iterator.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            iterator.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (source == null) continue;
                        if (throwable != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        source.close();
                    }
                }
            }
        }
        return estimates;
    }
}

