/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacheWriter;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

public class InputRelationshipCacheWriter
extends InputEntityCacheWriter {
    public InputRelationshipCacheWriter(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int chunkSize) throws IOException {
        super(channel, header, recordFormats, chunkSize);
    }

    @Override
    protected InputEntityCacheWriter.SerializingInputEntityVisitor instantiateWrapper(InputEntityVisitor visitor, int chunkSize) {
        return new SerializingInputRelationshipVisitor(visitor, chunkSize);
    }

    class SerializingInputRelationshipVisitor
    extends InputEntityCacheWriter.SerializingInputEntityVisitor {
        private String previousType;

        SerializingInputRelationshipVisitor(InputEntityVisitor actual, int chunkSize) {
            super(actual, chunkSize);
        }

        @Override
        protected void serializeEntity() throws IOException {
            this.writeProperties();
            this.writeGroup(this.startIdGroup, 0);
            this.writeGroup(this.endIdGroup, 1);
            this.writeValue(this.startId());
            this.writeValue(this.endId());
            if (this.hasIntType) {
                ByteBuffer buffer = this.buffer(5);
                buffer.put((byte)2);
                buffer.putInt(this.intType);
            } else if (this.previousType != null && this.stringType.equals(this.previousType)) {
                this.buffer(1).put((byte)0);
            } else {
                this.buffer(1).put((byte)1);
                this.previousType = this.stringType;
                this.writeToken((byte)2, this.previousType);
            }
        }

        @Override
        protected void clearState() {
            this.previousType = null;
            super.clearState();
        }
    }
}

