/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class NodeSetFirstGroupStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final int batchSize;
    private final ByteArray cache;
    private final RecordCursor<NodeRecord> nodeRecordCursor;
    private NodeRecord[] current;
    private int cursor;

    public NodeSetFirstGroupStep(StageControl control, Configuration config, RecordStore<NodeRecord> nodeStore, ByteArray cache) {
        super(control, "FIRST", config, 1, new StatsProvider[0]);
        this.cache = cache;
        this.batchSize = config.batchSize();
        this.nodeRecordCursor = nodeStore.newRecordCursor(nodeStore.newRecord());
        this.newBatch();
    }

    @Override
    public void start(int orderingGuarantees) {
        this.nodeRecordCursor.acquire(0L, RecordLoad.NORMAL);
        super.start(orderingGuarantees);
    }

    private void newBatch() {
        this.current = new NodeRecord[this.batchSize];
        this.cursor = 0;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender) throws Throwable {
        for (RelationshipGroupRecord group : batch) {
            long nodeId;
            if (!group.inUse() || this.cache.getByte(nodeId = group.getOwningNode(), 0) != 0) continue;
            this.cache.setByte(nodeId, 0, (byte)1);
            this.nodeRecordCursor.next(nodeId);
            NodeRecord node = ((NodeRecord)this.nodeRecordCursor.get()).clone();
            node.setNextRel(group.getId());
            node.setDense(true);
            this.current[this.cursor++] = node;
            if (this.cursor != this.batchSize) continue;
            sender.send(this.current);
            this.newBatch();
        }
        this.control.recycle(batch);
    }

    @Override
    protected void lastCallForEmittingOutstandingBatches(BatchSender sender) {
        if (this.cursor > 0) {
            sender.send(this.current);
        }
    }

    @Override
    public void close() throws Exception {
        this.nodeRecordCursor.close();
        super.close();
    }
}

