/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.storageengine.api.StorageProperty;

public interface PropertyContainerState {
    public static final PropertyContainerState EMPTY = new EmptyPropertyContainerState();

    public Iterator<StorageProperty> addedProperties();

    public Iterator<StorageProperty> changedProperties();

    public Iterator<Integer> removedProperties();

    public Iterator<StorageProperty> addedAndChangedProperties();

    public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> var1);

    public void accept(Visitor var1) throws ConstraintValidationException;

    public boolean hasPropertyChanges();

    public StorageProperty getChangedProperty(int var1);

    public StorageProperty getAddedProperty(int var1);

    public boolean isPropertyChangedOrRemoved(int var1);

    public boolean isPropertyRemoved(int var1);

    public static class EmptyPropertyContainerState
    implements PropertyContainerState {
        @Override
        public Iterator<StorageProperty> addedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> changedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<Integer> removedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> addedAndChangedProperties() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> iterator) {
            return iterator;
        }

        @Override
        public void accept(Visitor visitor) throws ConstraintValidationException {
        }

        @Override
        public boolean hasPropertyChanges() {
            return false;
        }

        @Override
        public StorageProperty getChangedProperty(int propertyKeyId) {
            return null;
        }

        @Override
        public StorageProperty getAddedProperty(int propertyKeyId) {
            return null;
        }

        @Override
        public boolean isPropertyChangedOrRemoved(int propertyKey) {
            return false;
        }

        @Override
        public boolean isPropertyRemoved(int propertyKeyId) {
            return false;
        }
    }

    public static interface Visitor {
        public void visitPropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, Iterator<Integer> var5) throws ConstraintValidationException;
    }
}

