/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Objects;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingPrimitiveLongIterator;
import org.neo4j.storageengine.api.txstate.PrimitiveLongDiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;

public class PrimitiveLongDiffSets<T extends PrimitiveLongIterator>
implements PrimitiveLongReadableDiffSets {
    private PrimitiveLongSet addedElements;
    private PrimitiveLongSet removedElements;

    public PrimitiveLongDiffSets() {
        this(PrimitiveLongCollections.emptySet(), PrimitiveLongCollections.emptySet());
    }

    public PrimitiveLongDiffSets(PrimitiveLongSet addedElements, PrimitiveLongSet removedElements) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
    }

    @Override
    public boolean isAdded(long element) {
        return this.addedElements.contains(element);
    }

    @Override
    public boolean isRemoved(long element) {
        return this.removedElements.contains(element);
    }

    public void removeAll(PrimitiveLongIterator elementsToRemove) {
        this.checkRemovedElements();
        while (elementsToRemove.hasNext()) {
            this.removeElement(elementsToRemove.next());
        }
    }

    public void addAll(PrimitiveLongIterator elementsToAdd) {
        this.checkAddedElements();
        while (elementsToAdd.hasNext()) {
            this.addElement(elementsToAdd.next());
        }
    }

    public void add(long element) {
        this.checkAddedElements();
        this.addElement(element);
    }

    public boolean remove(long element) {
        this.checkRemovedElements();
        return this.removeElement(element);
    }

    public void visit(PrimitiveLongDiffSetsVisitor visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        PrimitiveLongIterator addedItems = this.addedElements.iterator();
        while (addedItems.hasNext()) {
            visitor.visitAdded(addedItems.next());
        }
        PrimitiveLongIterator removedItems = this.removedElements.iterator();
        while (removedItems.hasNext()) {
            visitor.visitRemoved(removedItems.next());
        }
    }

    @Override
    public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, this.addedElements, this.removedElements);
    }

    @Override
    public int delta() {
        return this.addedElements.size() - this.removedElements.size();
    }

    @Override
    public PrimitiveLongSet getAdded() {
        return this.addedElements;
    }

    @Override
    public PrimitiveLongSet getRemoved() {
        return this.removedElements;
    }

    @Override
    public PrimitiveLongSet getAddedSnapshot() {
        return PrimitiveLongCollections.asSet((PrimitiveLongSet)this.addedElements);
    }

    @Override
    public boolean isEmpty() {
        return this.addedElements.isEmpty() && this.removedElements.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveLongDiffSets diffSets = (PrimitiveLongDiffSets)o;
        return Objects.equals(this.addedElements, diffSets.addedElements) && Objects.equals(this.removedElements, diffSets.removedElements);
    }

    public int hashCode() {
        return Objects.hash(this.addedElements, this.removedElements);
    }

    private void addElement(long element) {
        boolean removed = this.removedElements.remove(element);
        if (!removed) {
            this.addedElements.add(element);
        }
    }

    private boolean removeElement(long element) {
        boolean removed = this.addedElements.remove(element);
        return removed || this.removedElements.add(element);
    }

    private void checkAddedElements() {
        if (PrimitiveLongCollections.emptySet() == this.addedElements) {
            this.addedElements = Primitive.longSet();
        }
    }

    private void checkRemovedElements() {
        if (PrimitiveLongCollections.emptySet() == this.removedElements) {
            this.removedElements = Primitive.longSet();
        }
    }
}

