/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.helpers.collection.CastingIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.NodeCursor;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.NodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
ExplicitIndexWrite {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final StorageStatement statement;
    private final AutoIndexing autoIndexing;
    private NodeCursor nodeCursor;
    private final IndexTxStateUpdater updater;
    private PropertyCursor propertyCursor;
    private final Cursors cursors;
    private final NodeSchemaMatcher schemaMatcher;

    public Operations(AllStoreHolder allStoreHolder, IndexTxStateUpdater updater, StorageStatement statement, KernelTransactionImplementation ktx, Cursors cursors, AutoIndexing autoIndexing, NodeSchemaMatcher schemaMatcher) {
        this.autoIndexing = autoIndexing;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.statement = statement;
        this.updater = updater;
        this.cursors = cursors;
        this.schemaMatcher = schemaMatcher;
    }

    public void initialize() {
        this.nodeCursor = this.cursors.allocateNodeCursor();
        this.propertyCursor = this.cursors.allocatePropertyCursor();
    }

    public long nodeCreate() {
        this.ktx.assertOpen();
        long nodeId = this.statement.reserveNode();
        this.ktx.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    public boolean nodeDelete(long node) throws AutoIndexingKernelException {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            if (this.ktx.txState().nodeIsAddedInThisTx(node)) {
                this.autoIndexing.nodes().entityRemoved(this, node);
                this.ktx.txState().nodeDoDelete(node);
                return true;
            }
            if (this.ktx.txState().nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        if (this.allStoreHolder.nodeExistsInStore(node)) {
            this.autoIndexing.nodes().entityRemoved(this, node);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    public long relationshipCreate(long sourceNode, int relationshipLabel, long targetNode) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public void relationshipDelete(long relationship) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireSharedLabelLock(nodeLabel);
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        Iterator<ConstraintDescriptor> constraints = this.allStoreHolder.constraintsGetForLabel(nodeLabel);
        while (constraints.hasNext()) {
            IndexBackedConstraintDescriptor uniqueConstraint;
            IndexQuery.ExactPredicate[] propertyValues;
            ConstraintDescriptor constraint = constraints.next();
            if (!constraint.enforcesUniqueness() || (propertyValues = this.getAllPropertyValues((SchemaDescriptor)(uniqueConstraint = (IndexBackedConstraintDescriptor)constraint).schema(), -1, Values.NO_VALUE)) == null) continue;
            this.validateNoExistingNodeWithExactValues(uniqueConstraint, propertyValues, node);
        }
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        return true;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, node);
        }
    }

    private IndexQuery.ExactPredicate[] getAllPropertyValues(SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        IndexQuery.ExactPredicate[] values = new IndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        this.nodeCursor.properties(this.propertyCursor);
        while (this.propertyCursor.next()) {
            int nodePropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)nodePropertyId);
            if (k2 < 0) continue;
            if (nodePropertyId != -1) {
                values[k2] = IndexQuery.exact((int)nodePropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = IndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        try (NodeValueIndexCursor valueCursor = this.cursors.allocateNodeValueIndexCursor();){
            IndexDescriptor indexDescriptor = constraint.ownedIndexDescriptor();
            this.assertIndexOnline(indexDescriptor);
            int labelId = indexDescriptor.schema().getLabelId();
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyValues));
            this.allStoreHolder.nodeIndexSeek((IndexReference)this.allStoreHolder.indexGetCapability(indexDescriptor), valueCursor, IndexOrder.NONE, (IndexQuery[])propertyValues);
            if (valueCursor.next() && valueCursor.nodeReference() != modifiedNode) {
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(valueCursor.nodeReference(), -1L, IndexQuery.asValueTuple((IndexQuery.ExactPredicate[])propertyValues)));
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException(constraint, e);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.allStoreHolder.indexGetState(descriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
    }

    public boolean nodeRemoveLabel(long node, int nodeLabel) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.labels().contains(nodeLabel)) {
            return false;
        }
        this.ktx.txState().nodeDoRemoveLabel(nodeLabel, node);
        this.updater.onLabelChange(nodeLabel, this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws KernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, this.nodeCursor.labels().all());
        Iterator constraints = Iterators.filter((Predicate)SchemaDescriptorPredicates.hasProperty((int)propertyKey), this.allStoreHolder.constraintsGetAll());
        CastingIterator uniquenessConstraints = new CastingIterator(constraints, IndexBackedConstraintDescriptor.class);
        this.schemaMatcher.onMatchingSchema(uniquenessConstraints, this.nodeCursor, this.propertyCursor, propertyKey, (constraint, propertyIds) -> {
            Value previousValue;
            if (propertyIds.contains(propertyKey) && value.equals(previousValue = this.readNodeProperty(propertyKey))) {
                return;
            }
            this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.getAllPropertyValues((SchemaDescriptor)constraint.schema(), propertyKey, value), node);
        });
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue == Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyAdded(this, node, propertyKey, value);
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            this.updater.onPropertyAdd(this.nodeCursor, this.propertyCursor, propertyKey, value);
            return Values.NO_VALUE;
        }
        if (this.propertyHasChanged(value, existingValue)) {
            this.autoIndexing.nodes().propertyChanged(this, node, propertyKey, existingValue, value);
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, existingValue, value);
            this.updater.onPropertyChange(this.nodeCursor, this.propertyCursor, propertyKey, existingValue, value);
        }
        return existingValue;
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException, AutoIndexingKernelException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            this.autoIndexing.nodes().propertyRemoved(this, node, propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey, existingValue);
            this.updater.onPropertyRemove(this.nodeCursor, this.propertyCursor, propertyKey, existingValue);
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value relationshipRemoveProperty(long node, int propertyKey) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value graphSetProperty(int propertyKey, Value value) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public Value graphRemoveProperty(int propertyKey) {
        this.ktx.assertOpen();
        throw new UnsupportedOperationException();
    }

    public void nodeAddToExplicitIndex(String indexName, long node, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key, Object value) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    public void nodeRemoveFromExplicitIndex(String indexName, long node, String key) throws ExplicitIndexNotFoundKernelException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    public void nodeExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Node, indexName, customConfig);
    }

    public void nodeExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    public void relationshipAddToExplicitIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, ExplicitIndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key, Object value) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key, value);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship, String key) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship, key);
    }

    public void relationshipRemoveFromExplicitIndex(String indexName, long relationship) throws ExplicitIndexNotFoundKernelException, EntityNotFoundException {
        this.ktx.explicitIndexTxState().relationshipChanges(indexName).remove(relationship);
    }

    public void relationshipExplicitIndexCreate(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.ktx.explicitIndexTxState().createIndex(IndexEntityType.Relationship, indexName, customConfig);
    }

    public void relationshipExplicitIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.ktx.assertOpen();
        this.allStoreHolder.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor);
        Value existingValue = Values.NO_VALUE;
        while (this.propertyCursor.next()) {
            if (this.propertyCursor.propertyKey() != propertyKey) continue;
            existingValue = this.propertyCursor.propertyValue();
            break;
        }
        return existingValue;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
    }

    public Token token() {
        return this.allStoreHolder;
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.locks().optimistic().acquireExclusive(this.ktx.lockTracer(), ResourceTypes.NODE, node);
        }
    }

    private void acquireSharedLabelLock(int labelId) {
        this.ktx.locks().optimistic().acquireShared(this.ktx.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private boolean propertyHasChanged(Value lhs, Value rhs) {
        return lhs.getClass() != rhs.getClass() || !lhs.equals(rhs);
    }

    public ExplicitIndexRead indexRead() {
        return this.allStoreHolder;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public NodeCursor nodeCursor() {
        return this.nodeCursor;
    }

    public PropertyCursor propertyCursor() {
        return this.propertyCursor;
    }
}

