/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;

class NodeLabelIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.NodeLabelIndexCursor,
IndexProgressor.NodeLabelClient {
    private Read read;
    private long node = -1L;
    private LabelSet labels;
    private PrimitiveLongIterator added;
    private ReadableDiffSets<Long> changes;

    NodeLabelIndexCursor() {
    }

    @Override
    public void scan(IndexProgressor progressor, boolean providesLabels, int label) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().nodesWithLabelChanged(label);
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
    }

    @Override
    public void unionScan(IndexProgressor progressor, boolean providesLabels, int ... labels) {
        super.initialize(progressor);
        if (this.read.hasTxStateWithChanges()) {
            this.changes = this.read.txState().nodesWithAnyOfLabelsChanged(labels);
            this.added = this.changes.augment(PrimitiveLongCollections.emptyIterator());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void intersectionScan(IndexProgressor progressor, boolean providesLabels, int ... labels) {
        super.initialize(progressor);
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean acceptNode(long reference, LabelSet labels) {
        if (this.isRemoved(reference)) {
            return false;
        }
        this.node = reference;
        this.labels = labels;
        return true;
    }

    public boolean next() {
        if (this.added != null && this.added.hasNext()) {
            this.node = this.added.next();
            return true;
        }
        return this.innerNext();
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public LabelSet labels() {
        return this.labels;
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.labels = null;
        this.read = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.node + ", labels= " + this.labels + ", underlying record=" + super.toString() + " ]";
    }

    private boolean isRemoved(long reference) {
        return this.changes != null && this.changes.isRemoved(reference) || this.read.hasTxStateWithChanges() && this.read.txState().addedAndRemovedNodes().isRemoved(reference);
    }
}

